const React = require('react');
/*const connect = require('react-redux').connect;
const actions = require('../../js/actions');*/
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button,Select,Radio} from 'antd';
const Option = Select.Option;
const { RangePicker } = DatePicker;

class DashBoard extends React.Component{

	constructor(props){
		super(props);
		this.range = [moment().subtract(14,'days').format('YYYYMMDD'), moment().format('YYYYMMDD')];
		this.state= { logs :[],status:'pending',pagination:{current:1,pageSize:100,total:1},sort:'updatedAt' };
	}
	componentDidMount(){
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
		}
		let pagination = this.state.pagination;
		let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		api('GET', 'logs?'+'skip=0&limit=' + pagination.pageSize+'&sort=updatedAt').then((res) => {
			this.setState({logs:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
        });
	}

	getlogs(pagination,sort){
		this.setState({status:'pending'});
		api('GET', 'logs?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize + '&sort='+ sort).then((res) => {
			this.setState({logs:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
        });
	}

	onChange(pagination) {
  		//let data = { start:dateString[0],end:dateString[1]};
  		this.getlogs(pagination,this.state.sort);
  		//this.props.dispatch(actions.getMainData(data));
	}
	onChangeRange(date, dateString){

	}

	exportData(){

		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}
	handleSort(e){
		this.setState({sort:e.target.value});
		this.getlogs({current:1,pageSize:this.state.pagination.pageSize},e.target.value);

	}
	handleChange(value){
		var pagination = this.state.pagination;
		console.dir(pagination);
		pagination['current'] = 1;
		pagination['pageSize'] = parseInt(value);
		this.setState({pagination:pagination});
		this.getlogs(pagination,this.state.sort);
	}

	render(){
		console.dir(this.state.pagination);
		const columns = [
			{
			  title: '日期',
			  dataIndex: 'date',
			  key: 'date',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '淘口令',
			  dataIndex: 'info',
			  key: 'info',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},{
			  title: '请求数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 100,
			   render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广计划',
			  dataIndex: 'schedule',
			  key: 'schedule',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '渠道',
			  dataIndex: 'qd',
			  key: 'qd',
			  width: 100,
			  // sorter: (a, b) => { a.qd - b.qd},
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '状态',
			  dataIndex: 'status',
			  key: 'status',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},{
			  title: '最近更新',
			  dataIndex: 'update',
			  key: 'update',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			}
			];

			let range = this.range;
			var start = range[0];
			var end = range[1];
			let ranges = [];
			ranges.push(moment(start,'YYYYMMDD'));
			ranges.push(moment(end,'YYYYMMDD'));
			let data = [];
			let count = 0;
			let logs = this.state.logs;
			for(let i = 0;i<logs.length;i++){
				data.push({
					key:i,
					date:logs[i].date,
					info:logs[i].key,
					times:logs[i].times,
					status:logs[i].status == 'disable' ? '已归档' :'正常',
					schedule:(logs[i].schedule && logs[i].schedule['_id']) || '--',
					qd:(logs[i].schedule && logs[i].schedule['qd'] && logs[i].schedule['qd']['user']) || '--',
					update:logs[i].updatedAt
				});
			}
		
		return (
			<div>
			    <RangePicker onChange={ this.onChangeRange.bind(this) } value={ ranges } format={'YYYYMMDD'} style={{margin:'10px 0px'}}/>
			    <Button type="primary" icon="export"  onClick={ this.exportData.bind(this) } style={{ float:'right',margin:'10px 0px'}}>
          			导出数据
        		</Button>
		        <Radio.Group value = { this.state.sort } onChange={this.handleSort.bind(this)}  style={{ float:'right', "margin":'10px' }}>
		          <Radio.Button value="updatedAt">按更新</Radio.Button>
		          <Radio.Button value="status">按状态</Radio.Button>
		          <Radio.Button value="schedule">按计划</Radio.Button>
		          <Radio.Button value="date">按日期</Radio.Button>
		        </Radio.Group>
		        <Select
		          size ="default"
		          defaultValue="100"
		          value = { this.state.pagination.pageSize }
		          onChange={this.handleChange.bind(this)}
		          style={{ width: 100,float:'right', "margin":'10px'  }}
		        >
		        	<Option key='10'>10</Option>
		        	<Option key='20'>20</Option>
		        	<Option key='50'>50</Option>
		        	<Option key='100'>100</Option>
		        	<Option key='200'>200</Option>
		        	<Option key='500'>500</Option>
		        </Select>
			    <Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" pagination={ this.state.pagination } onChange = { this.onChange.bind(this)} bordered/>
			    </Spin>
			</div>
			)
	}
}

/*
function mapStateToProps (state) {
	return state;
}

module.exports = connect(mapStateToProps)(DashBoard);*/

module.exports = DashBoard;



