const React = require('react');
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Spin, Button,Badge,Form,Input,InputNumber,Row,Col,message,Card} from 'antd';
const FormItem = Form.Item;

class Tools extends React.Component{

	constructor(props){
		super(props);
		console.dir(this.props);
		this.state= { tkls:[],good:{title:'',pict_url:'',target:''} ,status:'pending'};
	}

	componentDidMount(){

	}

	handleSubmit(e){
		e.preventDefault();
	    var self = this;
	    this.props.form.validateFields((err, values) => {
	      if (!err) {
	      	console.dir(values);
	       /* api('POST', 'link',values).then((res) => {
            	if(res && res.result){
            		self.setModalVisible(false);
            		self.getLinks({limit:this.state.pagination.pageSize,skip:0});
            	}
        	});*/
        	self.getTkls(values);
	      }
	    });
	}

	getTkls(data){
		//this.setState({status:'pending'});
		api('POST', 'tool2_tbkls',data).then((res) => {
			//this.setState({details:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
			if(res.result && res.good) this.setState({tkls:res.result,good:res.good,status:'ready'});
			else message.warn('请求错误');
        });
	}


	render(){
		const { getFieldDecorator, getFieldsError, getFieldError, isFieldTouched } = this.props.form;
		var list = [];
		this.state.tkls.forEach(item => {
			list.push(<span className ='model' >{ item.model }</span>)
		});
		return (
			<div className ='tool-box'>
				<Form onSubmit={this.handleSubmit.bind(this)} className="login-form" style ={{ width:'50%','max-width': '350px','min-width': '300px','background': '#ddd','padding': '10px'}}>
					<FormItem
			          label="淘口令数量"
			        >
			          {getFieldDecorator('num', { initialValue: 10 })(
			            <InputNumber min={1} max={100} />
			          )}
			          <span className="ant-form-text">个</span>
			        </FormItem>
			      	<FormItem>
			          {getFieldDecorator('url', {
			            rules: [{ required: true, message: '链接不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>优惠券链接</span>} placeholder="例如：https://taoquan.taobao.com/coupon/unify_apply.htm?sellerId=2194810505&activityId=5c3186407cd441d48ecd2460815793e6" />
			          )}
			        </FormItem>
			        <FormItem>
			          {getFieldDecorator('logo', {
			            rules: [{ required: false, message: '图片链接不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>图片链接</span>}  placeholder="例如：https://detail.tmall.com/item.htm?id=40663494639" />
			          )}
			        </FormItem>
			         <FormItem>
			          {getFieldDecorator('text', {
			            rules: [{ required: true, message: '推广语' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>推广语</span>}  placeholder="例如：mm_33320967_40070156_153504280" />
			          )}
			        </FormItem>
			        <FormItem>
			          <Button type="primary" htmlType="submit" className="login-form-button">
			            一键生成
			          </Button>
			        </FormItem>
			      </Form>
			      {

			      	 this.state.status !== 'pending' ? 
					  <div style ={{ padding:'50px 30px','min-width':'500px'}}>	
					    	<div className ='label-info'>
					      		<label>LOGO大图</label>
					      		<img src = { this.state.good.logo } />	
					      	</div>
					    	<div className ='label-info'>
					      		<label>推广语</label>
					      		<div><p>{ this.state.good.text }</p></div>
					      	</div>
					      	<div className ='label-info'>
					      		<label>目标连接</label>
					      		<div><p>{ this.state.good.url }</p></div>
					      	</div>
					      	<label className='tkllabel'>淘口令</label>
					      	<div className = 'model-box'>
					      		{ list }
					      	</div>
				      	
			      </div> : <div className ='none'>填写内容，尝试生成淘口令吧 ~ ~</div>

			      }
			     
			</div>
			)
	}
}

Tools = Form.create()(Tools);
module.exports = Tools;




