'use strict';

var express = require('express');
var router = express.Router();

var controller = require( '../lib/controller.js' );
var session = require( '../lib/session.js' );

router.get('/logs',controller.logs);
router.post('/agent',controller.putAgent);
router.post('/tbkl',controller.putTbkl);
router.post('/session',session.login);
router.post('/to_tbkl',controller.createTbkl); //系统生成淘口令
router.get('/tbkls',controller.getTbkls);
router.get('/links',controller.getLinks);

router.post('/link',controller.createLink);


router.get('/schedules',controller.getSchedules);
router.post('/schedule',controller.createSchedule);

module.exports = router;