const React = require('react');
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button,Modal,Form,Input} from 'antd';
const { RangePicker } = DatePicker;
const FormItem = Form.Item;

class Agent extends React.Component{

	constructor(props){
		super(props);
		console.dir(this.props);
		this.state= { links :[],status:'pending',pagination:{current:1,pageSize:10,total:100},modalVisible:false,username:'channel'};
	}
	componentDidMount(){
		let pagination = this.state.pagination;
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1] == 'admin'){
			this.setState({username:'admin'});
		}
		//let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		api('GET', 'links?'+'skip=0&limit=' + pagination.pageSize).then((res) => {
			this.setState({links:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total},info:{quan:'',good:''}})
            console.dir(res.result);
        });
	}

	getLinks(pagination){
		console.dir(pagination);
		this.setState({status:'pending'})
		api('GET', 'links?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize).then((res) => {
			this.setState({links:res.result,status:'ready'})
            console.dir(res.result);
        });
	}

	onChange(pagination) {
		this.getLinks(pagination);
	}

	createLink(){
		this.setModalVisible(true);
	}

	setModalVisible(b){
		this.setState({modalVisible:b});
	}

	handleSubmit(e){
	    e.preventDefault();
	    var self = this;
	    this.props.form.validateFields((err, values) => {
	      if (!err) {
	        api('POST', 'link',values).then((res) => {
            	if(res && res.result){
            		self.setModalVisible(false);
            		self.getLinks({limit:this.state.limit,skip:0});
            	}
        	});
	      }
	    });
  }

	exportData(){
		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		const { getFieldDecorator, getFieldsError, getFieldError, isFieldTouched } = this.props.form;
		const columns = [
			{
			  title: '推广名称',
			  dataIndex: 'name',
			  key: 'name',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广语',
			  dataIndex: 'slogan',
			  key: 'slogan',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '优惠券链接',
			  dataIndex: 'quan',
			  key: 'quan',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},{
			  title: '商品连接',
			  dataIndex: 'good',
			  key: 'good',
			  width: 100,
			   render: text => <span href="#">{text}</span>,
			},
			{
			  title: 'PID',
			  dataIndex: 'pid',
			  key: 'pid',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '二合一',
			  dataIndex: 'target',
			  key: 'target',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广渠道',
			  dataIndex: 'qd',
			  key: 'qd',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '大图',
			  dataIndex: 'img',
			  key: 'img',
			  width: 100,
			  render: text => <img style= {{height:'70px'}} src = { text }/>,
			},
			{
			  title: '创建日期',
			  dataIndex: 'create',
			  key: 'create',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			}
			];
			let data = [];
			let links = this.state.links;
			for(let i = 0;i<links.length;i++){
				data.push({
					key:i,
					name:links[i].name,
					quan:links[i].quan,
					slogan:links[i].title,
					good:links[i].good,
					pid:links[i].pid,
					target:links[i].target,
					qd:(links[i].qd && links[i].qd['user']) || '暂无',
					img:links[i].pic,
					create:links[i].createdAt
				});
			}
		return (
			<div>
			    <Button type="primary" icon="export"  onClick={ this.createLink.bind(this) } style={{ margin:'10px 0px'}}>
          			创建
        		</Button>
			    <Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" pagination={ this.state.pagination } onChange = { this.onChange.bind(this)} bordered/>
			    </Spin>
			    <Modal
		          title="淘口令推广创建"
		          style={{ top: 30 }}
		          visible={this.state.modalVisible}
		          footer = { null }
		          onCancel = { this.setModalVisible.bind(this,false) }
		        >
			      <Form onSubmit={this.handleSubmit.bind(this)} className="login-form">
			       <FormItem>
			          {getFieldDecorator('name', {
			            rules: [{ required: true, message: '推广名称不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>推广名称</span>} placeholder="例如：推广1" />
			          )}
			        </FormItem>
			        <FormItem>
			          {getFieldDecorator('quan', {
			            rules: [{ required: true, message: '优惠券链接不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>优惠券链接</span>} placeholder="例如：https://taoquan.taobao.com/coupon/unify_apply.htm?sellerId=2194810505&activityId=5c3186407cd441d48ecd2460815793e6" />
			          )}
			        </FormItem>
			        <FormItem>
			          {getFieldDecorator('good', {
			            rules: [{ required: true, message: '商品连接不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>商品连接</span>}  placeholder="例如：https://detail.tmall.com/item.htm?id=40663494639" />
			          )}
			        </FormItem>
			         <FormItem>
			          {getFieldDecorator('pid', {
			            rules: [{ required: true, message: 'pid不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>PID</span>}  placeholder="例如：mm_33320967_40070156_153504280" />
			          )}
			        </FormItem>
			        <FormItem>
			          <Button type="primary" htmlType="submit" className="login-form-button">
			            一键生成
			          </Button>
			        </FormItem>
			      </Form>
		        </Modal>
			</div>
			)
	}
}

Agent = Form.create()(Agent);
module.exports = Agent;



