const cron = require('cron');
const nodemailer = require('nodemailer');
const Schedule = require('../db/mongo/tao-schedule');
const Data = require('../db/mongo/tao-data');
const Log = require('../db/mongo/tao-log');
const _ = require('lodash');
const moment = require('moment');
const controller = require('./controller');
const max = 400000;
var CronJob = cron.CronJob;
var job = new CronJob({
  cronTime: '00 26 15 * * 0-6',
  onTick: function() {
    tbklTask();
  },
  start: false,
});

async function sendMail(email,body) {
    var smtpTransport = nodemailer.createTransport({
        auth: {
            user: "liusong@goyoo.com",
            pass: "323609zhang"
        },
        host: 'smtp.exmail.qq.com',
        port: 465
    });
    var mailOptions = {
        from: "liusong@goyoo.com",
        to: email, //发给谁
        subject: '淘口令后台定时任务错误', //主题
        text: body
    };
    smtpTransport.sendMail(mailOptions, function (err, response) {
        if (!err) {
            console.log('发送邮件成功');
        } else {
            console.log('发送邮件失败，请重试');
        }
    });
}
async function tbklTask () {
	console.log('定时更新开始 =====> ');
	try {
      var date = moment().add(-1,'days').format('YYYYMMDD');
      var logDate = moment().add(-1,'days').toDate();
      var list = await Log.aggregate([
        {
          $match:{
            "date": date
          }
        },
        {
          $group:{
            _id: "$schedule",
            sum:{ $sum:"$times" }
          }
        }
      ]);
      var tasks = [];
      list.forEach( item => {
        var data = new Data({schedule:item._id,date:logDate,times:item.sum});
        tasks.push(data.save());
      });
      Promise.all(tasks).then(function(arr){
          console.log('插入' + arr.length + '条数据');
      });

	} catch (err) {
		console.dir(err);
		console.dir('更新异常 =====>');
		let mailList = 'liusong@goyoo.com';
		sendMail(mailList, err.toString());
	}
}

module.exports.start = function ()
{
    job.start();
};
