const config = require('../config/index');
const tao = require('./tao');
const mongoose = require('mongoose');
const moment = require('moment');
const Log = require('../db/mongo/tao-log');
const Kouling = require('../db/mongo/tao-kouling');
const Link = require('../db/mongo/tao-link');
const Session = require('../db/mongo/session');
const Agent = require('../db/mongo/tao-agent');
const Schedule = require('../db/mongo/tao-schedule');
const url = require('url');
const not_full = 'params not full error';
const not_right = 'params not right error';

function dateFormat(target,format) {
  return moment(new Date(target.getTime()),'x').format(format || 'YYYYMMDD HH:mm:ss');
};

function urlArgs(query) {
    var args = {};
    var pairs = query.split("&");
    for (var i = 0; i < pairs.length; i++) {
        var pos = pairs[i].indexOf("=");
        if (pos == -1) {
            continue;
        }
        var name = pairs[i].substring(0, pos);
        console.log(name);
        var value = pairs[i].substring(pos + 1);
        args[name] = value;
    }
    return args;
}
exports.putAgent = async  (req, res, next) => {
   	let {user,password,role = 'channel'} = req.body;
   	if(!user || !password) res.status(400).send(not_full);
   	else{
   		var u = await agent.findOne({user:user});
   		if(!u) 
   			tao.saveAgent({user,password,role},function(e,result){
   				res.send({status:'ok',result:result});
   			});
   		else 
   			res.status(400).send('already  exsits error');
   	}
}
exports.putTbkl = async (req, res, next) => {
  	let {info,creater,status = 'use'} = req.body;
   	if(!info || !creater) res.status(400).send(not_full);
   	else{
   		var kl = await Kouling.findOne({info:info});
   		creater = mongoose.Types.ObjectId(creater);
   		if(!kl) 
   			tao.saveKouling({info,creater,status},function(e,result){
   				res.send({status:'ok',result:result});
   			});
   		else 
   			res.status(400).send('already  exsits error');
   	}	 
};
exports.logs = async (req, res, next) => {
    let {start,end} = req.body;
    const condition = {'$and': [{'createdAt': {'$gte': moment(start, 'YYYYMMDD').startOf('day').toDate()}}, {'createdAt': {'$lt': moment(end, 'YYYYMMDD').endOf('day').toDate()}}]};
    let {limit = 100,skip = 0,sort = {'updatedAt': -1}} = req.query;
    let options = {limit:parseInt(limit),skip:parseInt(skip)*limit,sort};
    console.dir(options);
    var logs = await Log.find({},null,options).populate({path:"schedule",select:"links qd",populate:{path:'qd',select:'user'}});
    let total = await Log.count({},null);
    logs = logs.map(x => { var d = x.toJSON();d['updatedAt'] = dateFormat(d['updatedAt']);return d;});
    res.send({ status:'ok',result:logs,pagination:{total:total,skip:skip,limit:limit}});
}


exports.getGatherData = async (req, res, next) => {
    
    let {limit = 100,skip = 0,sort = {'updatedAt': -1}} = req.query;
    let options = {limit:parseInt(limit),skip:parseInt(skip)*limit,sort};
    var logs = await Log.find({},null,options).populate({path:"schedule",select:"links qd",populate:{path:'qd',select:'user'}});
    let total = await Log.count({},null);
    logs = logs.map(x => { var d = x.toJSON();d['updatedAt'] = dateFormat(d['updatedAt']);return d;});
    res.send({ status:'ok',result:logs,pagination:{total:total,skip:skip,limit:limit}});
}


exports.getTbkls = async (req, res, next) => {
    let {limit = 100,skip = 0,sort = {'updatedAt': -1}} = req.query;
    let options = {limit:parseInt(limit),skip:parseInt(skip)*limit,sort};
    let tbkls = await Kouling.find({},null,options).populate('link','title target');
    tbkls = tbkls.map(x => { var d = x.toJSON();d['createdAt'] = dateFormat(d['createdAt']);return d;});
    let total = await Kouling.count({},null);
    res.send({ status:'ok',result:tbkls,pagination:{total:total,skip:skip,limit:limit}});
}

exports.getLinks = async (req, res, next) => {
    let {limit = 100,skip = 0,sort = {'updatedAt': -1}} = req.query;
    let options = {limit:parseInt(limit),skip:parseInt(skip)*limit,sort};
    let links = await Link.find({},null,options).populate('qd','user role');
    links = links.map(x => { var d = x.toJSON();d['createdAt'] = dateFormat(d['createdAt']);return d;})
    let total = await Link.count({},null);
    res.send({ status:'ok',result:links,pagination:{total:total,skip:skip,limit:limit}});
}

exports.createLink = async (req, res, next) => {
    let {quan,pid,good,name} = req.body;
  /*  let sess = req.cookies['sess'];
    let sessBody = await Session.findById(sess).populate('user','user role');
    console.dir(sessBody.toJSON());
    return;*/
    if(!pid || !good || !quan  || !name ) 
       res.status(400).send(not_full);
    else{
      try {
        let quanQuery = urlArgs(url.parse(quan).query);
        let goodQuery = urlArgs(url.parse(good).query);
        if(!pid || !goodQuery['id'])
            res.status(400).send(not_full);
        else{
            let goodInfo  = await tao.getGood(goodQuery['id']); 
            let title = goodInfo['title'];
            let pic = goodInfo['pict_url'] || '';
            let target = 'https://uland.taobao.com/coupon/edetail?activityId='+ quanQuery['activityId']+'&itemId='+goodQuery['id']+'&pid='+pid+'&dx=1'; 
            tao.saveLink({name,quan,pid,good,title,pic,target},function(e,result){
              if(e) throw e;
              res.send({result:'ok',result:result})
            });
        }
      }catch(e){
        console.dir(e);
        res.status(400).send(e);
      }
    }
}

exports.getSchedules = async (req, res, next) => {
    let {limit = 100,skip = 0,sort = {'updatedAt': -1}} = req.query;
    let options = {limit:parseInt(limit),skip:parseInt(skip)*limit,sort};
    let schedules = await Schedule.find({},null,options).populate('links','name title target').populate('qd','user');
    let total = await Schedule.count({},null);
    res.send({ status:'ok',result:schedules,pagination:{total:total,skip:skip,limit:limit}});
}

exports.createSchedule = async (req, res, next) => {
    let {user,times,status='use',names} = req.body;
    var links = [];
    try{
        if(!user || !times || !names) 
           res.status(400).send(not_full);
        else{
          var agent = await Agent.findOne({user:user});
          names = names.split("@");
          names.forEach(async item => {
             links.push(Link.findOne({name:item}));
          });
          Promise.all(links).then(function(arr){
            arr = arr.map(x => x.toJSON()); //获取所有推广页id
            ids = arr.map(x => x._id);
            if(agent && ids.length){
              var qd = agent.toJSON()['_id'];
              var links = ids;
              var tkl_Tasks = [];
              tao.saveSchedule({qd,links,status,times},function(e,result){
                  if(e || !result._id) throw (e || result);
                  var schedule = result._id;
                  arr.forEach(async item => {
                    item['link'] = item._id;
                    item['schedule'] = schedule;
                    item['qd'] = qd;
                    for(let i = 0;i<5;i++){
                       tkl_Tasks.push(createTbkl(item));
                    }
                  });
                  Promise.all(tkl_Tasks).then(function(arrs){
                    arrs.map(x => x.toJSON());
                    res.send({status:'ok',result:result,kls:arrs});
                  });
              });
            }
            else{
              res.status(400).send(not_right);
            }
          });
        }
    }catch(e){
      console.dir(e);
      res.status(400).send(not_right);
    }
}

var createTbkl = async (data) => {
    let {title,target,pic,qd} = data;
    return new Promise(async (r,d) => {
        try {
          let tbklInfo = await tao.createTbkl(title,target,pic);
          let model = tbklInfo.model;
          let _data = { info:model,schedule:data.schedule,link:data.link,creater:qd,status:'use' };
          tao.saveKouling(_data,function(e,result){
            if(e) d(e);
            else r(result);
          });
        }catch(e){
          d(e);
        }
    });
}

exports.createTbkl = createTbkl;