const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    date: {
        type: Date,
        required: true
    },
    schedule:{
        type:ObjectId,
        required: true,
        ref:'tao-schedule'
    },
    times:{
        type:Number,
        required: true
    }
}, {
    timestamps: true
});

schema.index({date: 1});
schema.index({schedule: 1});
schema.index({date: 1,schedule: 1});
module.exports = mongoose.model('tao-data', schema);
