const types = require('./actionTypes');
const api = require('../api');

exports.fetchTest = (dispatch, getState) => {
    return (dispatch) => {
        api('GET', 'test').then((res) => {
            dispatch(setText(res.result));
        });
    };
};

exports.getSession = (data) => {
	return (dispatch) => {
        api('POST', 'session', data).then((res) => {
            if(res.result == 'ok'){
                location.href = "/manage";
                // dispatch({ status:'login', user:{ username:data.username,password:data.password }, type: types.LOGINSTATUS});
            }
        });
    };
}

exports.getMainData = (data) => {
    return (dispatch) => {
        api('POST', 'data', data).then((res) => {
            dispatch({status: 'pending', type: types.STATUS});
            dispatch({ status:res.result, data:res.data, type: types.MAINDATA});
        });
    };
}

exports.getCountData= () => {
    return (dispatch) => {
        api('GET', 'count').then((res) => {
            dispatch({ status:res.result, data:res.data, type: types.COUNTDATA});
        });
    };
}


exports.getDetailData = (data) => {
     return (dispatch) => {
        dispatch({status: 'pending', type: types.STATUS});
        api('POST', 'detail', data).then((res) => {
            dispatch({ status:res.result, data:res.data, type: types.DETAILDATA});
        });
    };  
}

exports.getMenu = () => {
    const mapLocations = ['/manage','/manage/statistics','/manage/setting'];
    let key = mapLocations.indexOf(location.pathname);
    return (dispatch) => {
        dispatch({currentPage:key, type: types.CURRENTPAGE})
        //dispatch({ data, type: types.CURRENTPAGE});
    };
}
