const React = require('react');
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button,Modal,Form,Input,Switch,message} from 'antd';
const { RangePicker } = DatePicker;
const FormItem = Form.Item;

class Schedule extends React.Component{

	constructor(props){
		super(props);
		console.dir(this.props);
		this.state= { schedules :[],status:'pending',pagination:{current:1,pageSize:10,total:1},modalVisible:false,username:'channel'};
	}
	componentDidMount(){
		let pagination = this.state.pagination;
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
		}
		//let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		api('GET', 'schedules?'+'skip=0&limit=' + pagination.pageSize).then((res) => {
			this.setState({schedules:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total},info:{quan:'',good:''}})
            console.dir(res.result);
        });
	}

	getschedules(pagination){
		console.dir(pagination);
		this.setState({status:'pending'})
		api('GET', 'schedules?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize).then((res) => {
			this.setState({schedules:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
            console.dir(res.result);
        });
	}

	onChange(pagination) {
		this.getschedules(pagination);
	}

	createSchedule(){
		this.setModalVisible(true);
	}

	setModalVisible(b){
		this.setState({modalVisible:b});
	}

	handleSubmit(e){
	    e.preventDefault();
	    var self = this;
	    this.props.form.validateFields((err, values) => {
	      if (!err) {
	      	console.dir(values)
	        api('POST', 'schedule',values).then((res) => {
            	if(res && res.result){
            		self.setModalVisible(false);
            		self.getschedules({limit:this.state.pagination.pageSize,skip:0});
            	}
        	});
	      }
	    });
  	}
  	checkUpdate(schedule){
  		var schedules = this.state.schedules;
  		var data = {
  			status:schedule['status'] == 'use' ? 'disable' : 'use',
  			scheduleId:schedule['id']
  		}
  		var self = this;
  		api('POST', 'schedule_update',data).then((res) => {
			if(res && res.schedule){
				if(data.status == 'use')
					message.success('执行成功, 生成'+ (res.new ? res.new.length : 0 )+" 条淘口令");
				else
					message.success('执行成功, 删除'+ (res.remove_result ? res.remove_result.nModified : 0 )+" 条淘口令");
				schedules[schedule['key']]['status'] = (schedule['status'] == 'use' ? 'disable' : 'use');
  				self.setState({schedules:schedules});
			}	
				//message.success('执行成功, 生成 '+(res.new ?  res.new.length : 0) +" 条,删除 "+ (res.remove_result ? res.remove_result.nModified : 0 )+" 条");
        });
  		
  	}
  	tklUpdate(schedule){
  		console.dir(schedule);
  		api('POST', 'newtkl',{id:schedule.id}).then((res) => {
			if(res && res.result =='ok')
				message.success('执行成功, 生成 '+(res.new ?  res.new.length : 0) +" 条,删除 "+ (res.remove_result ? res.remove_result.nModified : 0 )+" 条");
        });
  	}

	exportData(){
		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		const { getFieldDecorator, getFieldsError, getFieldError, isFieldTouched } = this.props.form;
		const columns = [
			{
			  title: '计划ID',
			  dataIndex: 'id',
			  key: 'id',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '分发ID/渠道',
			  dataIndex: 'qd',
			  key: 'qd',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广页名称',
			  dataIndex: 'names',
			  key: 'names',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '可用淘口令',
			  dataIndex: 'tkls',
			  key: 'tkls',
			  width: 10,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广次数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 50,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '创建日期',
			  dataIndex: 'create',
			  key: 'create',
			  width: 70,
			  render: text => <span href="#">{text}</span>,
			},{
			  title: '状态与操作',
			  dataIndex: 'status',
			  key: 'status',
			  width: 30,
			  render: (text,schedule) => <div><Switch checked={ text == 'use' ? true : false } onChange={this.checkUpdate.bind(this,schedule)} /><Button onClick = {this.tklUpdate.bind(this,schedule)}>生成淘口令</Button></div>,
			}
			];
			let data = [];
			let schedules = this.state.schedules;
			for(let i = 0;i<schedules.length;i++){
				let links = schedules[i].links;
				var names = "";
				links.forEach(function(link) {
					names += (" " + link['name']);
				});
				data.push({
					key:i,
					id:(schedules[i]._id && schedules[i]._id) || '--',
					names:names || '--',
					status:schedules[i].status,
					qd:((schedules[i].qd && schedules[i].qd['user']) || '--') + ' /' + ((schedules[i].qd && schedules[i].qd['_id']) || '--'),
					tkls:(schedules[i].count),
					times:schedules[i].times,
					create:schedules[i].createdAt
				});
			}
		return (
			this.state.username == 'admin' ?  <div>
			    <Button type="primary" icon="export"  onClick={ this.createSchedule.bind(this) } style={{ margin:'10px 0px'}}>
          			创建
        		</Button>
			    <Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" pagination={ this.state.pagination } onChange = { this.onChange.bind(this)} bordered/>
			    </Spin>
			    <Modal
		          title="推广计划创建"
		          style={{ top: 30 }}
		          visible={this.state.modalVisible}
		          footer = { null }
		          onCancel = { this.setModalVisible.bind(this,false) }
		        >
			      <Form onSubmit={this.handleSubmit.bind(this)} className="login-form">
			       <FormItem>
			          {getFieldDecorator('names', {
			            rules: [{ required: true, message: '推广页名称不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>推广名称</span>} placeholder="例如：商品1@商品2@商品3" />
			          )}
			        </FormItem>
			        <FormItem>
			          {getFieldDecorator('user', {
			            rules: [{ required: true, message: '渠道名称不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>渠道名称</span>} placeholder="例如：qd1" />
			          )}
			        </FormItem>
			        <FormItem>
			          {getFieldDecorator('times', {
			            rules: [{ required: true, message: '推广次数不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>推广次数</span>}  placeholder="例如：1000000" />
			          )}
			        </FormItem>
			        <FormItem>
			          <Button type="primary" htmlType="submit" className="login-form-button">
			            一键生成
			          </Button>
			        </FormItem>
			      </Form>
		        </Modal>
			</div>: <Alert
			      message="提示"
			      description="您没有权限"
			      type="warning"
			    />
			)
	}
}

Schedule = Form.create()(Schedule);
module.exports = Schedule;



