const React = require('react');
const connect = require('react-redux').connect;
const actions = require('../js/actions');
const api = require('../js/api');

import { Menu,Icon,Button,Layout,Breadcrumb}  from 'antd';
const SubMenu = Menu.SubMenu;
const MenuItemGroup = Menu.ItemGroup;
const ButtonGroup = Button.Group;
const { Header, Footer, Sider, Content } = Layout;

const mapLocations = ['/manage/statistics','/manage','/manage/ips','/manage/setting','/manage/tkl','/manage/schedule','/manage/qd','/manage/tools','/manage/tools_num2']

class Main extends React.Component{
	constructor(props){
		super(props);
		this.map = ['口令数据','汇总数据','IP数据','推广页面管理','淘口令','推广计划','渠道管理','小工具','小工具2'];
		console.dir(location.pathname);
		var pathname = location.pathname;
		console.dir(mapLocations.indexOf(pathname));
		this.state = {
		    current: mapLocations.indexOf(pathname) >= 0 ? mapLocations.indexOf(pathname) : 0,
		    openKeys: [],
		    theme: 'dark',
		    username:null
		}
	}

	handleClick(e){
		//this.props.dispatch(actions.getMenu());
		this.setState({current:e.key})
		if(e.key == 9){
			api('GET', 'logout').then(function(res){
				if(res.result == 'ok') location.href = '/';
			});
		}
		else
			location.href = mapLocations[ e.key ];
  	}

  	onOpenChange(openKeys){
  		this.setState({ openKeys: openKeys });
  	}

	componentWillMount(){
		if(this.props.login && this.props.login.status == 'logout') 
			location.href = '/'
		const { dispatch } = this.props;
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
		}
	}

	render(){
		console.log(this.state.current);
		return (
			<Layout className="layout">
			    <Header>
			      <div className="logo" >
			      	<span>媒体后台</span>
			      </div>
			      <Menu
			        theme="dark"
			        mode="horizontal"
			        defaultSelectedKeys = {[ this.state.current ]}
			        onClick={ this.handleClick.bind(this) }
			        style={{ lineHeight: '64px' }}
			      >
			        <SubMenu title={<span>数据统计</span>}>
			         	<Menu.Item key="1">汇总数据</Menu.Item>
			            <Menu.Item key="0">口令数据</Menu.Item>
			            <Menu.Item key="2">IP数据</Menu.Item>
			        </SubMenu>
			        <Menu.Item key="3">推广页管理</Menu.Item>
			        <Menu.Item key="4">淘口令</Menu.Item>
			        <Menu.Item key="5">推广计划</Menu.Item>
			        <Menu.Item key="6">渠道管理</Menu.Item>
			        <Menu.Item key="7">小工具</Menu.Item>
			        <Menu.Item key="8">小工具2</Menu.Item>
			        <Menu.Item key="9" style ={{ float:'right'}}><Icon type="logout" />{ this.state.username }</Menu.Item>
			      </Menu>
			    </Header>
			    <Content style={{ padding: '0 50px' }}>
			      <Breadcrumb style={{ margin: '12px 0' }}>
			        <Breadcrumb.Item>{  parseInt(this.state.current) < 3 ? '数据统计' : '配置与管理'}</Breadcrumb.Item>
			        <Breadcrumb.Item>{  this.map[ this.state.current ]}</Breadcrumb.Item>
			      </Breadcrumb>
			      <div style={{ background: '#fff', padding: 24, minHeight: 280 }}>{
			      	this.props.children
			      }</div>
			    </Content>
			    <Footer style={{ textAlign: 'center' }}>
			      xiaoyun.com ©2017 Created by xiaoyun
			    </Footer>
			  </Layout>
		)
	}
}

/*function mapStateToProps (state) {
	return state;
}*/
module.exports = Main;