

const React = require('react');
const redux = require('redux');
const rootReducer = require('../reducers');

const createDevTools = require('redux-devtools-ie8').createDevTools;
const LogMonitor = require('redux-devtools-log-monitor-ie8').default;
const DockMonitor = require('redux-devtools-dock-monitor-ie8').default;
import sequenceAction from 'redux-sequence-action';

const thunk = require('redux-thunk').default;

const ReduxDevTools =  createDevTools(
	<DockMonitor 
		toggleVisibilityKey = 'ctrl-h' 
		changePositionKey = 'ctrl-w'
	>
		<LogMonitor />
	</DockMonitor>
) ;
module.exports.configureStore = function configureStore () {
	
	return redux.createStore(
		rootReducer,
		redux.compose(
			redux.applyMiddleware(thunk,sequenceAction),
			ReduxDevTools.instrument()
		)
	)

}
module.exports.ReduxDevTools = ReduxDevTools;

