const config = require('../config/index');
const tao = require('./tao');
const mongoose = require('mongoose');
const moment = require('moment');
const Log = require('../db/mongo/tao-log');
const Kouling = require('../db/mongo/tao-kouling');
const Link = require('../db/mongo/tao-link');
const Session = require('../db/mongo/session');
const Agent = require('../db/mongo/tao-agent');
const Schedule = require('../db/mongo/tao-schedule');
const url = require('url');
const not_full = 'params not full error';
const not_right = 'params not right error';

function dateFormat(target,format) {
  console.dir(target.getTime());
  return moment(new Date(target.getTime()),'x').format(format || 'YYYYMMDD HH:mm:ss');
};

function urlArgs(query) {
    var args = {};
    var pairs = query.split("&");
    for (var i = 0; i < pairs.length; i++) {
        var pos = pairs[i].indexOf("=");
        if (pos == -1) {
            continue;
        }
        var name = pairs[i].substring(0, pos);
        console.log(name);
        var value = pairs[i].substring(pos + 1);
        args[name] = value;
    }
    return args;
}
exports.putAgent = async  (req, res, next) => {
   	let {user,password,role = 'channel'} = req.body;
   	if(!user || !password) res.status(400).send(not_full);
   	else{
   		var u = await agent.findOne({user:user});
   		if(!u) 
   			tao.saveAgent({user,password,role},function(e,result){
   				res.send({status:'ok',result:result});
   			});
   		else 
   			res.status(400).send('already  exsits error');
   	}
}
exports.putTbkl = async (req, res, next) => {
  	let {info,creater,status = 'use'} = req.body;
   	if(!info || !creater) res.status(400).send(not_full);
   	else{
   		var kl = await Kouling.findOne({info:info});
   		creater = mongoose.Types.ObjectId(creater);
   		if(!kl) 
   			tao.saveKouling({info,creater,status},function(e,result){
   				res.send({status:'ok',result:result});
   			});
   		else 
   			res.status(400).send('already  exsits error');
   	}	 
};
exports.logs = async (req, res, next) => {
  try{
    var options = {limit: 1000, skip: 0, sort: {'updatedAt':-1}};
    var logs = await Log.find({},null,options).populate('qd','user role');
    logs = logs.map(x => { var d = x.toJSON();d['updatedAt'] = dateFormat(d['updatedAt']);return d;});
    res.send({ status:'ok',result:logs });
  } catch(e){
    console.dir(e);
  }
   
}

exports.getTbkls = async (req, res, next) => {
    let {limit = 1000,skip = 0,sort = {'updatedAt': -1}} = req.query;
    let options = {limit:parseInt(limit),skip:parseInt(skip),sort};
    let tbkls = await Kouling.find({},null,options).populate('creater','user role').populate('good','title quan pid good');
    let total = await Kouling.count({},null);
    res.send({ status:'ok',result:tbkls,pagination:{total:total,skip:skip,limit:limit}});
}

exports.getLinks = async (req, res, next) => {
    let {limit = 100,skip = 0,sort = {'updatedAt': -1}} = req.query;
    let options = {limit:parseInt(limit),skip:parseInt(skip),sort};
    let tbkls = await Link.find({},null,options).populate('qd','user role');
    let total = await Link.count({},null);
    res.send({ status:'ok',result:tbkls,pagination:{total:total,skip:skip,limit:limit}});
}

exports.createLink = async (req, res, next) => {
    let {quan,pid,good,name} = req.body;
  /*  let sess = req.cookies['sess'];
    let sessBody = await Session.findById(sess).populate('user','user role');
    console.dir(sessBody.toJSON());
    return;*/
    if(!pid || !good || !quan  || !name ) 
       res.status(400).send(not_full);
    else{
      try {
        let quanQuery = urlArgs(url.parse(quan).query);
        let goodQuery = urlArgs(url.parse(good).query);
        if(!pid || !goodQuery['id'])
            res.status(400).send(not_full);
        else{
            let goodInfo  = await tao.getGood(goodQuery['id']); 
            let title = goodInfo['title'];
            let pic = goodInfo['pict_url'] || '';
            let target = 'https://uland.taobao.com/coupon/edetail?activityId='+ quanQuery['activityId']+'&itemId='+goodQuery['id']+'&pid='+pid+'&dx=1'; 
            tao.saveLink({name,quan,pid,good,title,pic,target},function(e,result){
              if(e) throw e;
              res.send({result:'ok',result:result})
            });
        }
      }catch(e){
        console.dir(e);
        res.status(400).send(e);
      }
    }
}

exports.getSchedules = async (req, res, next) => {
    let {limit = 100,skip = 0,sort = {'updatedAt': -1}} = req.query;
    let options = {limit:parseInt(limit),skip:parseInt(skip),sort};
    let schedules = await Schedule.find({},null,options).populate('qd','user role').populate('taolink','name title target');
    let total = await Schedule.count({},null);
    res.send({ status:'ok',result:schedules,pagination:{total:total,skip:skip,limit:limit}});
}

exports.createSchedule = async (req, res, next) => {
    let {user,times,status='use',name} = req.body;
    try{
        if(!user || !times || !name) 
           res.status(400).send(not_full);
        else{
          var agent = await Agent.findOne({user:user});
          var link = await Link.findOne({name:name});
          if(agent && link){
              let qd = agent.toJSON()['_id'];
              let taolink = link.toJSON()['_id'];
              tao.saveSchedule({qd,taolink,status,times},function(e,result){
                if(e) throw e;
                res.send({status:'ok',result:result});
              });
          }
          else{
            res.status(400).send(not_right);
          }
        }
    }catch(e){
      res.status(400).send(not_right);
    }
}

exports.createTbkl = async (req, res, next) => {
    /*let {quan,pid,good,title,qd} = req.body;
    let quanQuery = urlArgs(url.parse(quan).query);
    let goodQuery = urlArgs(url.parse(good).query);
    //console.dir(quanQuery);
    try {
      if(!pid || !quanQuery['activityId'] || !goodQuery['id'])
        res.status(400).send(not_full);
      else{
        let urlTarget = 'https://uland.taobao.com/coupon/edetail?activityId='+ quanQuery['activityId']+'&itemId='+goodQuery['id']+'&pid='+pid; 
        let goodInfo  = await tao.getGood(goodQuery['id']); 
        let tbklInfo = await tao.createTbkl(goodInfo['title'],urlTarget);
        let model = tbklInfo.model;
        //console.dir(title);
        console.dir(tbkl);
      }

    }catch(e){
       res.status(400).send(e);
    }*/
    //res.send({ status:'ok',result:{} });
}

