const React = require('react');
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button,Modal,Form,Input} from 'antd';
const { RangePicker } = DatePicker;
const FormItem = Form.Item;

class Schedule extends React.Component{

	constructor(props){
		super(props);
		console.dir(this.props);
		this.state= { schedules :[],status:'pending',pagination:{current:1,pageSize:10,total:100},modalVisible:false,username:'channel'};
	}
	componentDidMount(){
		let pagination = this.state.pagination;
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1] == 'admin'){
			this.setState({username:'admin'});
		}
		//let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		api('GET', 'schedules?'+'skip=0&limit=' + pagination.pageSize).then((res) => {
			this.setState({schedules:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total},info:{quan:'',good:''}})
            console.dir(res.result);
        });
	}

	getschedules(pagination){
		console.dir(pagination);
		this.setState({status:'pending'})
		api('GET', 'schedules?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize).then((res) => {
			this.setState({schedules:res.result,status:'ready'})
            console.dir(res.result);
        });
	}

	onChange(pagination) {
		this.getschedules(pagination);
	}

	createSchedule(){
		this.setModalVisible(true);
	}

	setModalVisible(b){
		this.setState({modalVisible:b});
	}

	handleSubmit(e){
	    e.preventDefault();
	    var self = this;
	    this.props.form.validateFields((err, values) => {
	      if (!err) {
	      	console.dir(values)
	        api('POST', 'schedule',values).then((res) => {
            	if(res && res.result){
            		self.setModalVisible(false);
            		self.getschedules({limit:this.state.limit,skip:0});
            	}
        	});
	      }
	    });
  }

	exportData(){
		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		const { getFieldDecorator, getFieldsError, getFieldError, isFieldTouched } = this.props.form;
		const columns = [
			{
			  title: '推广名称',
			  dataIndex: 'name',
			  key: 'name',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广链接',
			  dataIndex: 'target',
			  key: 'target',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广渠道',
			  dataIndex: 'qd',
			  key: 'qd',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广次数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '创建日期',
			  dataIndex: 'create',
			  key: 'create',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			}
			];
			let data = [];
			let schedules = this.state.schedules;
			for(let i = 0;i<schedules.length;i++){
				data.push({
					key:i,
					name:schedules[i].taolink && schedules[i].taolink['name'] || '--',
					target:schedules[i].taolink && schedules[i].taolink['target'] || '--',
					qd:schedules[i].qd && schedules[i].qd['user'] || '--',
					times:schedules[i].times,
					create:schedules[i].createdAt
				});
			}
		return (
			<div>
			    <Button type="primary" icon="export"  onClick={ this.createSchedule.bind(this) } style={{ margin:'10px 0px'}}>
          			创建
        		</Button>
			    <Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" pagination={ this.state.pagination } onChange = { this.onChange.bind(this)} bordered/>
			    </Spin>
			    <Modal
		          title="推广计划创建"
		          style={{ top: 30 }}
		          visible={this.state.modalVisible}
		          footer = { null }
		          onCancel = { this.setModalVisible.bind(this,false) }
		        >
			      <Form onSubmit={this.handleSubmit.bind(this)} className="login-form">
			       <FormItem>
			          {getFieldDecorator('name', {
			            rules: [{ required: true, message: '推广名称不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>推广名称</span>} placeholder="例如：推广1" />
			          )}
			        </FormItem>
			        <FormItem>
			          {getFieldDecorator('user', {
			            rules: [{ required: true, message: '渠道名称不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>渠道名称</span>} placeholder="例如：qd1" />
			          )}
			        </FormItem>
			        <FormItem>
			          {getFieldDecorator('times', {
			            rules: [{ required: true, message: '推广次数不能为空' }],
			          })(
			            <Input prefix={<span style={{ fontSize: 13 }}>推广次数</span>}  placeholder="例如：1000000" />
			          )}
			        </FormItem>
			        <FormItem>
			          <Button type="primary" htmlType="submit" className="login-form-button">
			            一键生成
			          </Button>
			        </FormItem>
			      </Form>
		        </Modal>
			</div>
			)
	}
}

Schedule = Form.create()(Schedule);
module.exports = Schedule;



