const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    key: {
        type: String,
        required: true
    },
    schedule:{
        type:ObjectId,
        required: true,
        ref:'tao-schedule'
    },
    link: {
        type:ObjectId,
        required: true,
        ref:'tao-link'
    },
    times:{
        type:Number,
        required: true
    },
    status:{
        type:String,
        required: false 
    },
    date:{
        type:String,
        required: true
    },
}, {
    timestamps: true
});

schema.index({key: 1});
module.exports = mongoose.model('tao-log', schema);
