const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    date: {
        type: Date,
        required: true
    },
    qd:{
        type:ObjectId,
        required: true,
        ref:'tao-agent'  
    },
    schedules:{
        type:Array,
        required:true
    },
    times:{
        type:Number,
        required: true
    },
    dc_times:{
        type:Number,
        required: false
    }
}, {
    timestamps: true
});

schema.index({date: 1});
schema.index({qd: 1});
schema.index({date: 1,qd: 1});
module.exports = mongoose.model('tao-data', schema);
