const React = require('react');
/*const connect = require('react-redux').connect;
const actions = require('../../js/actions');*/
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button,Popover} from 'antd';
const { RangePicker } = DatePicker;

class Gather extends React.Component{

	constructor(props){
		super(props);
		this.range = [moment().subtract(6,'days').format('YYYYMMDD'), moment().format('YYYYMMDD')];
		this.state= { qdgathers :[],status:'pending',pagination:{current:1,pageSize:10,total:100},username:'channel',tody:{ tkl_count:0,count:0,schedule_count:0} ,none_tkls:[],list:[]};
	}
	componentDidMount(){
		let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
		}
		api('GET', 'gathers/qd').then((res) => {
			this.setState({qdgathers:res.result,status:'ready',none_tkls:res.none_tkls,list:res.list});
			this.handle(res.list,res.tkl_count)
        });
	}

	handle(list,tkl_count){
		var sum = 0;
		for(var k in list){
			sum += (list[k]['sum'] || 0);
		}
		this.setState({tody:{tkl_count:tkl_count,schedule_count:list.length,count:sum}});
	}


	getQdGatherss(pagination){
		this.setState({status:'pending'})
		api('GET', 'gathers/qd?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize).then((res) => {
			this.setState({qdgathers:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total},none_tkls:res.none_tkls,list:res.list});
			this.handle(res.list,res.tkl_count);
        });
	}

	onChange(date, dateString) {
  		let data = { start:dateString[0],end:dateString[1]};
  		//this.props.dispatch(actions.getMainData(data));
	}

	exportData(){

		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		const columns = [
			{
			  title: '日期',
			  dataIndex: 'date',
			  key: 'date',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '渠道／分发ID',
			  dataIndex: 'user',
			  key: 'user',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '请求数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 100,
			   render: text => <span href="#">{text}</span>,
			},
			{
			  title: '导出数',
			  dataIndex: 'dc_times',
			  key: 'dc_times',
			  width: 100,
			   render: text => <span href="#">{text}</span>,
			},
			{
			  title: '导出率(%)',
			  dataIndex: 'rate',
			  key: 'rate',
			  width: 100,
			   render: text => <span href="#">{text}</span>,
			}
			];

			let range = this.range;
			var start = range[0];
			var end = range[1];
			let ranges = [];
			ranges.push(moment(start,'YYYYMMDD'));
			ranges.push(moment(end,'YYYYMMDD'));
			let data = [];
			let count = 0;
			let qdgathers = this.state.qdgathers;
			for(let i = 0;i<qdgathers.length;i++){
				data.push({
					key:i,
					date:qdgathers[i].date,
					user:(qdgathers[i].qd && qdgathers[i].qd.user) + ' / ' + (qdgathers[i].qd && qdgathers[i].qd._id),
					times:qdgathers[i].times || 0,
					dc_times:qdgathers[i].dc_times || 0,
					rate:qdgathers[i].dc_times / qdgathers[i].times ?  ((qdgathers[i].dc_times / qdgathers[i].times).toFixed(6) * 100).toFixed(3) :  0
				});
			}
			var none_tkls = this.state.none_tkls;
			var list = this.state.list;
			var sum = 0;
			var list_show = [];
			var sum_list_show = [];
			for(var i in none_tkls){
				sum += none_tkls[i]['times'];
				let qd = none_tkls[i]["qd"];
				if(qd) list_show.push(<p key={ qd['user'] }>{qd['user'] + "  " +none_tkls[i]['times']}</p>)
			}
			var map2qd = {};
			for(var k in list){
				if(list[k] && list[k].qd && list[k]['qd']['user'])
					map2qd[list[k]['qd']['user']] = (map2qd[list[k]['qd']['user']] ? (map2qd[list[k]['qd']['user']]+list[k]['sum']) : list[k]['sum']);
			}
			for(var j in map2qd){
				sum_list_show.push(<p key={ j }>{j + "  " +map2qd[j]}</p>);
			}
			const content = (
			  <div>
			    { list_show }
			  </div>
			);
			const sum_content = (
				<div>
			    { sum_list_show }
			  </div>);
		
		return (
			<div>
				<div>
					<Row>
					  <Col span="6">
				      	<div className = "box" style={{ marginLeft:'0px'}}>
				      		<h3>请求数</h3>{
				      			this.state.username !== 'admin' ? <span>{ this.state.tody.count }</span> :
				      			<Popover content={sum_content} title="详情">
				      				<span>{ this.state.tody.count }</span>
						    	</Popover>
				      		}
				      		
				      	</div>
				      </Col>
				      <Col span="6">
				      	<div className = "box" style={{ marginLeft:'0px'}}>
				      		<h3>投放计划</h3>
				      		<span>{ this.state.tody.schedule_count }</span>
				      	</div>
				      </Col>
				      {
				      	this.state.username !== 'admin' ?  <Col span="6">
				      	<div className = "box" style={{ marginLeft:'0px'}}>
				      		<h3>导出数</h3>
				      		<span>次日发布</span>
				      	</div>
				      </Col> : <Col span="6">
				      	<div className = "box" style={{ marginLeft:'0px'}}>
				      		<h3>无效请求</h3>
				      		<Popover content={content} title="详情">
				      			<span>{ sum }</span>
						    </Popover>
				      	</div>
				      </Col>
				      }
				      <Col span="6">
				      	<div className = "box">
				      		<h3>淘口令数</h3>
				      		<span>{ this.state.tody.tkl_count }</span>
				      	</div>
				      </Col>
					</Row>	
				</div>
			    <RangePicker onChange={ this.onChange.bind(this) } value={ ranges } format={'YYYYMMDD'} style={{margin:'10px 0px'}}/>
			    <Button type="primary" icon="export"  onClick={ this.exportData.bind(this) } style={{ float:'right',margin:'10px 0px'}}>
          			导出数据
        		</Button>
			    <Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" bordered/>
			    </Spin>
			</div>
			)
	}
}

/*
function mapStateToProps (state) {
	return state;
}

module.exports = connect(mapStateToProps)(DashBoard);*/

module.exports = Gather;



