const React = require('react');
/*const connect = require('react-redux').connect;
const actions = require('../../js/actions');*/
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button} from 'antd';
const { RangePicker } = DatePicker;

class Gather extends React.Component{

	constructor(props){
		super(props);
		this.range = [moment().subtract(6,'days').format('YYYYMMDD'), moment().format('YYYYMMDD')];
		this.state= { qdgathers :[],status:'pending',pagination:{current:1,pageSize:10,total:100},username:'channel' };
	}
	componentDidMount(){
		let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		api('GET', 'gathers/qd').then((res) => {
			this.setState({qdgathers:res.result,status:'ready'})
            console.dir(res.result);
        });
	}


	getQdGatherss(pagination){
		console.dir(pagination);
		this.setState({status:'pending'})
		api('GET', 'gathers/qd?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize).then((res) => {
			this.setState({qdgathers:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
            console.dir(res.result);
        });
	}

	onChange(date, dateString) {
  		let data = { start:dateString[0],end:dateString[1]};
  		//this.props.dispatch(actions.getMainData(data));
	}

	exportData(){

		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		const columns = [
			{
			  title: '日期',
			  dataIndex: 'date',
			  key: 'date',
			  width: 100,
			  render: text => <a href="#">{text}</a>,
			},
			{
			  title: '渠道／分发ID',
			  dataIndex: 'user',
			  key: 'user',
			  width: 100,
			  render: text => <a href="#">{text}</a>,
			},
			{
			  title: '请求数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 100,
			   render: text => <a href="#">{text}</a>,
			},
			{
			  title: '导出数',
			  dataIndex: 'dc_times',
			  key: 'dc_times',
			  width: 100,
			   render: text => <a href="#">{text}</a>,
			},
			{
			  title: '导出率(%)',
			  dataIndex: 'rate',
			  key: 'rate',
			  width: 100,
			   render: text => <a href="#">{text}</a>,
			}
			];

			let range = this.range;
			var start = range[0];
			var end = range[1];
			let ranges = [];
			ranges.push(moment(start,'YYYYMMDD'));
			ranges.push(moment(end,'YYYYMMDD'));
			let data = [];
			let count = 0;
			let qdgathers = this.state.qdgathers;
			for(let i = 0;i<qdgathers.length;i++){
				data.push({
					key:i,
					date:qdgathers[i].date,
					user:(qdgathers[i].qd && qdgathers[i].qd.user) + ' / ' + (qdgathers[i].qd && qdgathers[i].qd._id),
					times:qdgathers[i].times || 0,
					dc_times:qdgathers[i].dc_times || 0,
					rate:qdgathers[i].dc_times / qdgathers[i].times ?  ((qdgathers[i].dc_times / qdgathers[i].times).toFixed(6) * 100).toFixed(3) :  0
				});
			}
		
		return (
			<div>
			    <RangePicker onChange={ this.onChange.bind(this) } value={ ranges } format={'YYYYMMDD'} style={{margin:'10px 0px'}}/>
			    <Button type="primary" icon="export"  onClick={ this.exportData.bind(this) } style={{ float:'right',margin:'10px 0px'}}>
          			导出数据
        		</Button>
			    <Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" bordered/>
			    </Spin>
			</div>
			)
	}
}

/*
function mapStateToProps (state) {
	return state;
}

module.exports = connect(mapStateToProps)(DashBoard);*/

module.exports = Gather;



