const React = require('react');
/*const connect = require('react-redux').connect;
const actions = require('../../js/actions');*/
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button} from 'antd';
const { RangePicker } = DatePicker;

class DashBoard extends React.Component{

	constructor(props){
		super(props);
		this.range = [moment().subtract(6,'days').format('YYYYMMDD'), moment().format('YYYYMMDD')];
		this.state= { logs :[],status:'pending',pagination:{current:1,pageSize:100,total:1} };
	}
	componentDidMount(){
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
		}
		let pagination = this.state.pagination;
		let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		api('GET', 'logs?'+'skip=0&limit=' + pagination.pageSize).then((res) => {
			this.setState({logs:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
            console.dir(res.result);
        });
	}

	getlogs(pagination){
		this.setState({status:'pending'});
		api('GET', 'logs?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize).then((res) => {
			this.setState({logs:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
            console.dir(res.result);
        });
	}

	onChange(pagination) {
  		//let data = { start:dateString[0],end:dateString[1]};
  		this.getlogs(pagination);
  		//this.props.dispatch(actions.getMainData(data));
	}
	onChangeRange(date, dateString){

	}

	exportData(){

		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		const columns = [
			{
			  title: '日期',
			  dataIndex: 'date',
			  key: 'date',
			  width: 100,
			  render: text => <a href="#">{text}</a>,
			},
			{
			  title: '淘口令',
			  dataIndex: 'info',
			  key: 'info',
			  width: 100,
			  render: text => <a href="#">{text}</a>,
			},{
			  title: '请求数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 100,
			   render: text => <a href="#">{text}</a>,
			},
			{
			  title: '推广计划',
			  dataIndex: 'schedule',
			  key: 'schedule',
			  width: 100,
			  render: text => <a href="#">{text}</a>,
			},
			{
			  title: '渠道',
			  dataIndex: 'qd',
			  key: 'qd',
			  width: 100,
			  render: text => <a href="#">{text}</a>,
			},
			{
			  title: '状态',
			  dataIndex: 'status',
			  key: 'status',
			  width: 100,
			  render: text => <a href="#">{text}</a>,
			},{
			  title: '最近更新',
			  dataIndex: 'update',
			  key: 'update',
			  width: 100,
			  render: text => <a href="#">{text}</a>,
			}
			];

			let range = this.range;
			var start = range[0];
			var end = range[1];
			let ranges = [];
			ranges.push(moment(start,'YYYYMMDD'));
			ranges.push(moment(end,'YYYYMMDD'));
			let data = [];
			let count = 0;
			let logs = this.state.logs;
			for(let i = 0;i<logs.length;i++){
				console.dir(logs[i]);
				data.push({
					key:i,
					date:logs[i].date,
					info:logs[i].key,
					times:logs[i].times,
					status:logs[i].status == 'disable' ? '已归档' :'正常',
					schedule:(logs[i].schedule && logs[i].schedule['_id']) || '--',
					qd:(logs[i].schedule && logs[i].schedule['qd'] && logs[i].schedule['qd']['user']) || '--',
					update:logs[i].updatedAt
				});
			}
		
		return (
			this.state.username == 'admin' ? <div>
			    <RangePicker onChange={ this.onChangeRange.bind(this) } value={ ranges } format={'YYYYMMDD'} style={{margin:'10px 0px'}}/>
			    <Button type="primary" icon="export"  onClick={ this.exportData.bind(this) } style={{ float:'right',margin:'10px 0px'}}>
          			导出数据
        		</Button>
			    <Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" pagination={ this.state.pagination } onChange = { this.onChange.bind(this)} bordered/>
			    </Spin>
			</div>: <Alert
			      message="提示"
			      description="您没有权限"
			      type="warning"
			/>
			)
	}
}

/*
function mapStateToProps (state) {
	return state;
}

module.exports = connect(mapStateToProps)(DashBoard);*/

module.exports = DashBoard;



