const React = require('react');
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button} from 'antd';
const { RangePicker } = DatePicker;

class Tbkls extends React.Component{

	constructor(props){
		super(props);
		console.dir(this.props);
		this.state= { tbkls :[],status:'pending',pagination:{current:1,pageSize:10,total:100},modalVisible:false,username:'channel'};
	}
	componentDidMount(){
		let pagination = this.state.pagination;
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
		}
		//let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		api('GET', 'tbkls?'+'skip=0&limit=' + pagination.pageSize).then((res) => {
			this.setState({tbkls:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total},info:{quan:'',good:''}})
            console.dir(res.result);
        });
	}

	gettbkls(pagination){
		console.dir(pagination);
		this.setState({status:'pending'})
		api('GET', 'tbkls?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize).then((res) => {
			this.setState({tbkls:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
            console.dir(res.result);
        });
	}

	onChange(pagination) {
		this.gettbkls(pagination);
	}


	exportData(){
		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		
		const columns = [
			{
			  title: '淘口令',
			  dataIndex: 'info',
			  key: 'info',
			  width: 60,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '商品信息',
			  dataIndex: 'good',
			  key: 'good',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广连接',
			  dataIndex: 'target',
			  key: 'target',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '所属计划',
			  dataIndex: 'schedule',
			  key: 'schedule',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '状态',
			  dataIndex: 'status',
			  key: 'status',
			  width: 40,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '创建日期',
			  dataIndex: 'create',
			  key: 'create',
			  width: 50,
			  render: text => <span href="#">{text}</span>,
			}
			];
			let data = [];
			let tbkls = this.state.tbkls;
			for(let i = 0;i<tbkls.length;i++){
				data.push({
					key:i,
					info:tbkls[i].info ,
					good:(tbkls[i].link && tbkls[i].link['title']) || '--',
					schedule:tbkls[i].schedule,
					target:(tbkls[i].link && tbkls[i].link['target']) || '--',
					status:tbkls[i].status == 'use' ? '进行中' : '已失效',
					create:tbkls[i].createdAt
				});
			}
		return (
			this.state.username == 'admin' ? <div>
				<Alert
			      message="提示"
			      description="淘口令油后台任务自动生成"
			      type="info"
			    />
				<Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" pagination={ this.state.pagination } onChange = { this.onChange.bind(this)} bordered/>
			    </Spin>
			</div>: <Alert
			      message="提示"
			      description="您没有权限"
			      type="warning"
			    />
			)
	}
}

module.exports = Tbkls;



