const React = require('react');
const connect = require('react-redux').connect;
const actions = require('../js/actions');
const api = require('../js/api');

import { Menu,Icon,Button,Layout,Breadcrumb}  from 'antd';
const SubMenu = Menu.SubMenu;
const MenuItemGroup = Menu.ItemGroup;
const ButtonGroup = Button.Group;
const { Header, Footer, Sider, Content } = Layout;

const mapLocations = ['/manage/statistics','/manage','/manage/setting','/manage/tkl','/manage/schedule']

class Main extends React.Component{
	constructor(props){
		super(props);
		this.map = ['数据统计','数据统计','配置','淘口令','渠道管理']
		this.state = {
		    current: '1',
		    openKeys: [],
		    theme: 'dark',
		    username:null
		}
	}

	handleClick(e){
		//this.props.dispatch(actions.getMenu());
		if(e.key == 5){
			api('GET', 'logout',function(res){
				console.dir(res);
			});
		}
		else
			location.href = mapLocations[ e.key ];
  	}

  	onOpenChange(openKeys){
  		this.setState({ openKeys: openKeys });
  	}

	componentWillMount(){
		if(this.props.login && this.props.login.status == 'logout') 
			location.href = '/'
		const { dispatch } = this.props;
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
		}
	}

	render(){
		console.log(this.props.menu.currentPage);
		return (
			<Layout className="layout">
			    <Header>
			      <div className="logo" >
			      	<span>媒体后台</span>
			      </div>
			      <Menu
			        theme="dark"
			        mode="horizontal"
			        defaultSelectedKeys = {[ this.props.menu.currentPage +'' ]}
			        onClick={ this.handleClick.bind(this) }
			        style={{ lineHeight: '64px' }}
			      >
			        <SubMenu title={<span>数据统计</span>}>
			         	<Menu.Item key="1">汇总数据</Menu.Item>
			            <Menu.Item key="0">口令数据</Menu.Item>
			        </SubMenu>
			        <Menu.Item key="2">推广页管理</Menu.Item>
			        <Menu.Item key="3">淘口令</Menu.Item>
			        <Menu.Item key="4">推广计划</Menu.Item>
			        <Menu.Item key="5" style ={{ float:'right'}}><Icon type="logout" />{ this.state.username }</Menu.Item>
			      </Menu>
			    </Header>
			    <Content style={{ padding: '0 50px' }}>
			      <Breadcrumb style={{ margin: '12px 0' }}>
			        <Breadcrumb.Item>{ this.map[ this.props.menu.currentPage ]}</Breadcrumb.Item>
			        <Breadcrumb.Item>{ this.props.menu.currentPage == '0' ? '数据统计' : (this.props.menu.currentPage == '0' ? '汇总数据' : "配置" )}</Breadcrumb.Item>
			      </Breadcrumb>
			      <div style={{ background: '#fff', padding: 24, minHeight: 280 }}>{
			      	this.props.children
			      }</div>
			    </Content>
			    <Footer style={{ textAlign: 'center' }}>
			      xiaoyun.com ©2017 Created by xiaoyun
			    </Footer>
			  </Layout>
		)
	}
}

function mapStateToProps (state) {
	return state;
}
module.exports = connect(mapStateToProps)(Main);