const React = require('react');
const moment = require('moment');
const api = require('../../js/api');
import ReactEcharts from "echarts-for-react";

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button,Popover,Form,Input,Modal,InputNumber,message,Select} from 'antd';
const FormItem = Form.Item;
const { RangePicker } = DatePicker;

class Gather extends React.Component{

	constructor(props){
		super(props);
		//this._t = null;
		this.range = [moment().subtract(14,'days').format('YYYYMMDD'), moment().format('YYYYMMDD')];
		this.state= { range:this.range,currentQd:'all',qds:[],qdgathers :[],status:'pending',pagination:{current:1,pageSize:20,total:100},username:'channel',tody:{ tkl_count:0,count:0,schedule_count:0} ,none_tkls:[],list:[],modalVisible:false,xAxis:[],series:[],loading:true};
	}
	componentDidMount(){
		//let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
			if(document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1] == 'admin')
				api('GET', 'qds?skip=0&limit=1000').then((res) => {
					this.setState({qds:res.result});
        		});

		}
		api('GET', 'gathers/qd?skip=0&limit=20').then((res) => {
			this.setState({qdgathers:res.result,status:'ready',none_tkls:res.none_tkls,list:res.list,pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}});
			this.handle(res.list,res.tkl_count)
        });
	}

	onChartReady(chart){
		//console.dir('in onChartReady');
		var self = this;
		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.getCharts(this.range[0],this.range[1]);
			chart.hideLoading();
		}
	   /* this._t = setTimeout(function() {
	      chart.hideLoading();
	    }, 3000);*/
	}

	getCharts(start,end){
		var self = this;
		this.setState({loading:true});
		api('GET','gatherall?start=' +start+ '&end=' + end).then((res) => {
				if(res.status == 'ok' && res.list && res.list.length){
					var times = [];
					var dc_times = [];
					var xAxis = [];
					res.list.sort(function(a,b){ return parseInt(a._id) - parseInt(b._id) });
					for(var k in res.list){
						var item = res.list[k];
						times.push(item.times);
						dc_times.push(item.dc_times);
						xAxis.push(item.date);
					}
					self.setState({series:[ {
				          name:'请求数',
				          type:'line',
				          stack: '总量',
				          areaStyle: {normal: {}},
				          data:times
				        },
				        {
				          name:'导出数',
				          type:'line',
				          stack: '总量',
				          areaStyle: {normal: {}},
				          data:dc_times
				        }],xAxis:xAxis,loading:false});
				}
				else
					message.warn('取数错误');
				
				//this.setState({}});
        });
	}

	getLoadingOption(){
		//console.dir('in getLoadingOption');
	    return {
	      text: '加载中...',
	      color: '#4413c2',
	      textColor: '#270240',
	      maskColor: '#108ee982',//'rgba(194, 88, 86, 0.3)',
	      zlevel: 0
	    };
	}


  	getOption(){
	    return {
	      title: {
	        text: '每日走势图'
	      },
	      tooltip : {
	        trigger: 'axis'
	      },
	      legend: {
	        data:['请求数','导出数']
	      },
	      toolbox: {
	        feature: {
	          saveAsImage: {}
	        }
	      },
	      grid: {
	        left: '3%',
	        right: '4%',
	        bottom: '3%',
	        containLabel: true
	      },
	      xAxis : [
	        {
	          type : 'category',
	          boundaryGap : false,
	          data : this.state.xAxis
	        }
	      ],
	      yAxis : [
	        {
	          type : 'value'
	        }
	      ],
	      series :  this.state.series
	    };
  	}
	handle(list,tkl_count){
		var sum = 0;
		for(var k in list){
			sum += (list[k]['sum'] || 0);
		}
		this.setState({tody:{tkl_count:tkl_count,schedule_count:list.length,count:sum}});
	}


	getQdGathers(pagination,qd){
		this.setState({status:'pending'});
		var url = 'gathers/qd?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize;
		if(qd && qd !== 'all' && this.state.username == 'admin')
			url += ('&qd='+ qd);
		api('GET',url).then((res) => {
			this.setState({qdgathers:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total},none_tkls:res.none_tkls,list:res.list});
			this.handle(res.list,res.tkl_count);
        });
	}

	onChange(pagination) {
  		//let data = { start:dateString[0],end:dateString[1]};
  		//this.props.dispatch(actions.getMainData(data));
  		this.getQdGathers(pagination,this.state.currentQd);
	}

	dc_timesChange(data,value){
		console.dir(data);
		console.dir(value);
		var key = data['key'];
		var qdgathers = this.state.qdgathers;
		console.dir(qdgathers.length + '====');
		qdgathers[key]['dc_times'] = value;
		this.setState({qdgathers:qdgathers})
	}
	componentWillUnmount() {
    	//clearTimeout(this._t);
  	};

	onChangeDate(date,dateString){
		//let data = { start:dateString[0],end:dateString[1]};
		//this.range = ;
		this.setState({range:[dateString[0],dateString[1]]});
		this.getCharts(dateString[0],dateString[1])
		//console.dir(data);
	}

	exportData(){

		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	setModalVisible(b){
		this.setState({modalVisible:b});
	}

	detaiShow(){
		this.setModalVisible(true);
	}

	putexData(data){
		console.dir(data);
		api('POST','put_data',{dc_times:data['dc_times'],id:data['id']}).then( res => {
		 	message.success('执行成功, 影响'+ (res.result ? res.result.nModified : 0 )+" 条数据");
		});
	}

	handleSubmit(){

	}

	handleChange(value) {
		this.setState({currentQd:value});
		this.getQdGathers({pageSize:this.state.pagination.pageSize,current:1},value)
	  //console.log(`selected ${value}`);
	}

	detailData(data){
		console.dir(data);
		var date = data.date;
		var qd = data.qd;
		location.href = '/manage/detail?qd='+qd+'&date='+date
	}

	render(){
		const { getFieldDecorator, getFieldsError, getFieldError, isFieldTouched } = this.props.form;
		const columns = [
			{
			  title: '日期',
			  dataIndex: 'date',
			  key: 'date',
			  width: 40,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '渠道／分发ID',
			  dataIndex: 'user',
			  key: 'user',
			  width: 120,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '请求数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 50,
			   render: text => <span href="#">{text}</span>,
			},
			{
			  title: '导出数',
			  dataIndex: 'dc_times',
			  key: 'dc_times',
			  width: 50,
			   render: text => <span href="#">{text}</span>,
			},
			{
			  title: '导出率(%)',
			  dataIndex: 'rate',
			  key: 'rate',
			  width: 50,
			   render: text => <span href="#">{text}</span>,
			}
			];
		const modal_columns = [
			{
			  title: '日期',
			  dataIndex: 'date',
			  key: 'date',
			  width: 40,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '渠道',
			  dataIndex: 'user',
			  key: 'user',
			  width: 10,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '推广页',
			  dataIndex: 'page',
			  key: 'page',
			  width: 100,
			   render: text => <span href="#">{text}</span>,
			},
			{
			  title: '请求数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 50,
			   render: text => <span href="#">{text}</span>,
			}
			];
			if(this.state.username == 'admin'){
				columns.push({
				  title: '详情',
				  dataIndex: 'detail',
				  key: 'detail',
				  width: 10,
				  render: (text,data) => <Popover placement="left"  content={ text } title="详情 (计划ID - 商品页 - 请求数)">
					      						<Button type="primary">
	          										详情
	        									</Button>
							    			</Popover>
				});

				columns.push({
				  title: '操作',
				  dataIndex: 'put',
				  key: 'put',
				  width: 10,
				  render: (text,data) =><div>
				  							<InputNumber min={0} max={1000000000000000}  value = { text || 0 } onChange = { this.dc_timesChange.bind(this,data)}/>
				  						 	<Button type="primary" icon="plus"  onClick={ this.putexData.bind(this,data) } style = {{ marginLeft:'10px' }}>
			          							录入
			        					 	</Button>
			        					</div>
				});
			}
			let children = [<Select.Option key='all'>全部</Select.Option>];
			for (var  i = 0; i < this.state.qds.length; i++) {
				let item = this.state.qds[i];
			  children.push(<Select.Option key={item._id}>{ item.user }</Select.Option>);
			}

			let range = this.state.range;
			var start = range[0];
			var end = range[1];
			let ranges = [];
			ranges.push(moment(start,'YYYYMMDD'));
			ranges.push(moment(end,'YYYYMMDD'));
			let data = [];
			let modal_data = [];
			let count = 0;
			let qdgathers = this.state.qdgathers;
			
			for(let i = 0;i<qdgathers.length;i++){
				var item = qdgathers[i];
				var detail_list_show = [];
				var data_item = {
					key:i,
					id:item._id,
					qd:(item.qd && item.qd._id),
					date:item.date,
					user:(item.qd && item.qd.user) + ' / ' + (item.qd && item.qd._id),
					times:item.times || 0,
					dc_times:item.dc_times || 0,
					put:item.dc_times || 0,
					rate:item.dc_times / item.times ?  ((item.dc_times / item.times).toFixed(6) * 100).toFixed(3) :  0
				}
				if(this.state.username == 'admin'){
						if(item.schedules && item.schedules.length)
							item.schedules.sort((a,b) => { return b.times - a.times });
						for(var j = 0;j < item.schedules.length; j++){
								var _item = item.schedules[j];
								var schedule_id = _item.schedule && _item.schedule._id;
								var links = '';
								if(_item.schedule && _item.schedule.links)
									links = _item.schedule.links.map( x => x.name).join(',')
								var times = _item.times;
								modal_data.push({
									key:i + '' + j,
									date:item.date,
									user:(item.qd && item.qd.user),
									page:links,
									times:times
								});
								detail_list_show.push(<div className="detail-body-list" key={ schedule_id }><span>{  schedule_id  }</span><span>{ links }</span><span>{ times }</span></div>);
						}
						var  detail_content = (
						<div>
						 { detail_list_show }
						</div>
						);
						data_item['detail']=detail_content;
				}
				data.push(data_item);
			}
			var none_tkls = this.state.none_tkls;
			var list = this.state.list;
			var sum = 0;
			var list_show = [];
			var sum_list_show = [];
			for(var i in none_tkls){
				sum += none_tkls[i]['times'];
				let qd = none_tkls[i]["qd"];
				let iplimit = none_tkls[i]["iplimit"] || 0;
			    list_show.push(<div className="detail-body" key={ Math.random() }><span>{ qd && qd['user'] || '未知'}</span><span>{ iplimit == 1 ? 'ip限制' : 'bug' }</span><span>{ none_tkls[i]['times'] }</span></div>)
			}
			var map2qd = {};
			for(var k in list){
				if(list[k] && list[k].qd && list[k]['qd']['user'])
					map2qd[list[k]['qd']['user']] = (map2qd[list[k]['qd']['user']] ? (map2qd[list[k]['qd']['user']]+list[k]['sum']) : list[k]['sum']);
			}
			for(var j in map2qd){
				sum_list_show.push(<div className="detail-body" key={ j }><span>{j}</span><span>{ map2qd[j] }</span></div>);
			}

			const content = (
			  <div>
			    { list_show }
			  </div>
			);
			const sum_content = (
				<div>
			    { sum_list_show }
			  </div>);
		return (
			<div>
				<div>
					<Row>
					  <Col span="6">
				      	<div className = "box" style={{ marginLeft:'0px'}}>
				      		<h3>请求数</h3>{
				      			this.state.username !== 'admin' ? <span>{ this.state.tody.count }</span> :
				      			<Popover placement="bottom"  content={sum_content} title="详情">
				      				<span>{ this.state.tody.count }</span>
						    	</Popover>
				      		}
				      		
				      	</div>
				      </Col>
				      <Col span="6">
				      	<div className = "box" style={{ marginLeft:'0px'}}>
				      		<h3>投放计划</h3>
				      		<span>{ this.state.tody.schedule_count }</span>
				      	</div>
				      </Col>
				      {
				      	this.state.username !== 'admin' ?  <Col span="6">
				      	<div className = "box" style={{ marginLeft:'0px'}}>
				      		<h3>导出数</h3>
				      		<span>次日发布</span>
				      	</div>
				      </Col> : <Col span="6">
				      	<div className = "box" style={{ marginLeft:'0px'}}>
				      		<h3>无效请求</h3>
				      		<Popover placement="bottom"  content={content} title="详情">
				      			<span>{ sum }</span>
						    </Popover>
				      	</div>
				      </Col>
				      }
				      <Col span="6">
				      	<div className = "box">
				      		<h3>淘口令数</h3>
				      		<span>{ this.state.tody.tkl_count }</span>
				      	</div>
				      </Col>
					</Row>	
				</div>
			    { this.state.username == 'admin' ? <RangePicker onChange={ this.onChangeDate.bind(this) } value={ ranges } format={'YYYYMMDD'} style={{margin:'10px 0px'}}/> : <div></div> }
			    { this.state.username == 'admin' ? <ReactEcharts
           		 option={this.getOption()}
           		 style={{height: '350px', width: '100%',margin:'20px 0px'}}
           		 onChartReady={this.onChartReady.bind(this)}
            	 loadingOption={this.getLoadingOption.bind(this)()}
            	 showLoading={this.state.loading} 
            	 className='react_for_echarts' /> : <div></div>}
            	<div style={{ overflow:"hidden"}}>
			    <Button type="primary" icon="export"  onClick={ this.exportData.bind(this) } style={{ float:'right',margin:'10px 0px'}}>
          			导出数据
        		</Button>
        		{
        			this.state.username == 'admin' ?
        				    <Button type="primary" onClick={ this.detaiShow.bind(this) } style={{ float:'right',margin:'10px'}}>
			          			本页详情
			        		</Button> : <div></div>
			    }
			    {

					this.state.username == 'admin' ?  <Modal
				          title="数据详情"
				          style={{ top: 30 }}
				          visible={this.state.modalVisible}
				          footer = { null }
				          onCancel = { this.setModalVisible.bind(this,false) }
				        > 	
				        <Table columns={ modal_columns } dataSource = { modal_data }  size="middle" bordered/>

					</Modal> : <div></div>
        		}
        		{
        			this.state.username == 'admin' ? <Select
				    style={{ float:'left',width:200,margin:'10px 0px'}}
				    placeholder="输入渠道名称"
				    defaultValue="all"
				    onChange={this.handleChange.bind(this)}
				  >
				    {children}
				  </Select>: <div></div>
				}
			 	</div>
			    <Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data } pagination={ this.state.pagination } onChange = { this.onChange.bind(this)}  size="middle" bordered/>
			    </Spin>
			</div>
			)
	}
}

/*
function mapStateToProps (state) {
	return state;
}

module.exports = connect(mapStateToProps)(DashBoard);*/
Gather = Form.create()(Gather);
module.exports = Gather;



