const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    name: {
        type: String,
        required: true,
        unique: true
    },
    quan: {
        type: String,
        required: true
    },
    good:{
        type: String,
        required: true
    },
    pid:{
        type: String,
        required: true
    },
    title:{
        type: String,
        required: true
    },
    pic:{
        type: String,
        required: false
    },
    target:{
        type:String,
        required:true,
    },
    qd:{
        type:ObjectId,
        required:false,
        ref:'tao-agent'
    },
    status:{
        type:String,
        required:false
    }
}, {
    timestamps: true
});

schema.index({name: 1});
module.exports = mongoose.model('tao-link', schema);
