const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    date: {
        type: Date,
        required: true
    },
    qd:{
        type:ObjectId,
        required: true,
        ref:'tao-agent'  
    },
    schedules:[{
        schedule:{
            type:ObjectId,
            ref:'tao-schedule' 
        },
        times:{
            type:Number
        }
    }],
    times:{
        type:Number,
        required: true
    },
    dc_times:{
        type:Number,
        required: false
    }
}, {
    timestamps: true
});

schema.index({date: 1});
schema.index({qd: 1});
schema.index({date: 1,qd: 1});
module.exports = mongoose.model('tao-data', schema);
