const React = require('react');
const moment = require('moment');
const api = require('../../js/api');

import json2xlsx from '../../js/json2xlsx';

import { Table, Icon, DatePicker, Alert, Row, Col, Spin, Button,Badge} from 'antd';
const { RangePicker } = DatePicker;

class Details extends React.Component{

	constructor(props){
		super(props);
		console.dir(this.props);
		this.state= { details :[],status:'pending',pagination:{current:1,pageSize:10,total:100},modalVisible:false,username:'channel',qd:null,date:null};
	}

	getQueryString(name) {
	    var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
	    var r = window.location.search.substr(1).match(reg);
	    if (r != null) {
	        return unescape(r[2]);
	    }
	    return null;
	}

	componentDidMount(){

		let pagination = this.state.pagination;
		//alert(this.getQueryString('date') + this.getQueryString('qd'));
		let qd = this.getQueryString('qd');
		let date = this.getQueryString('date');
		this.setState({qd:qd,date:date});

		if(document.cookie.match('username=[a-zA-Z0-9]+')[0] && document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]){
			this.setState({username:document.cookie.match('username=[a-zA-Z0-9]+')[0].split('=')[1]});
		}
		//let data = { start:moment().add(-6,'days').format('YYYYMMDD'),end:moment().format('YYYYMMDD')};
		api('GET', 'details?'+'skip=0&limit=' + pagination.pageSize+'&qd='+qd+'&date='+date).then((res) => {
			this.setState({details:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total},info:{quan:'',good:''}})
            console.dir(res.result);
        });
	}

	getdetails(pagination){
		console.dir(pagination);
		this.setState({status:'pending'});
		api('GET', 'details?'+'skip='+ (pagination.current-1) + '&limit=' + pagination.pageSize +'&qd=' + this.state.qd+'&date=' + this.state.date).then((res) => {
			this.setState({details:res.result,status:'ready',pagination:{current:res.pagination.skip,pageSize:res.pagination.limit,total:res.pagination.total}})
            console.dir(res.result);
        });
	}

	onChange(pagination) {
		this.getdetails(pagination);
	}


	exportData(){
		//json2xlsx(data,{sheetName:"基础数据", filename : '基础数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		
		const columns = [
			{
			  title: '渠道',
			  dataIndex: 'qd',
			  key: 'qd',
			  width: 60,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '计划ID',
			  dataIndex: 'schedule',
			  key: 'schedule',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '商品页面',
			  dataIndex: 'link',
			  key: 'link',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '淘口令',
			  dataIndex: 'tkl',
			  key: 'tkl',
			  width: 100,
			  render: text => <span href="#">{text}</span>,
			},
			{
			  title: '请求数',
			  dataIndex: 'times',
			  key: 'times',
			  width: 40,
			  render: text => <span href="#">{text}</span>
			}
			];
			let data = [];
			let details = this.state.details;
			for(let i = 0;i<details.length;i++){
				data.push({
					key:i,
					qd:details[i].info ,
					schedule:details[i].schedule,
					link:(details[i].link && details[i].link['target']) || '--',
					tkl:details[i].status,
					times:details[i].createdAt
				});
			}
		return (
			<div>
				<Alert
			      message="提示"
			      description="淘口令油后台任务自动生成"
			      type="info"
			    />
				<Spin spinning= { this.state.status == 'pending' }>
			    	<Table columns={columns} dataSource = { data }  size="middle" pagination={ this.state.pagination } onChange = { this.onChange.bind(this)} bordered/>
			    </Spin>
			</div>
			)
	}
}

module.exports = Details;



