/* eslint-disable */
import * as _ from 'lodash';
import testDatas from '@/tests/consumers';
import moment from 'moment';
import { Toast } from 'mint-ui';

const types = {
  GET_RECOGNITIONS: 'GET_RECOGNITIONS',
  GET_NUMBERS: 'GET_NUMBERS',
  NUMBERS_LOADING: 'NUMBERS_LOADING',
  UPDATE_PAGINATION: 'UPDATE_PAGINATION',
  CALL_BEGIN: 'CALL_BEGIN',
};

const state = {
  numbers: [],
  calledNumbers: [],
  numbersLoading: false,
  page: {
    skip: 0,
    total: 0,
  },
  pageCalled: {
    skip: 0,
    total: 0,  
  }
};

const getters = {
  recognitions(state) {
    return formatNumbers(state.numbers).length;
  },
  getConsumers() {
    console.dir(state.numbers);
    return state.numbers;
  },
  getCalledConsumers() {
    console.dir(state.calledNumbers)
    return state.calledNumbers.map(x => {
      if( x.calledInfo && x.calledInfo.length) {
        const last = x.calledInfo[x.calledInfo.length - 1 ];
        console.dir(last);
        x.startTime =  last.TaskInfo && last.TaskInfo.startTime > 0 ? moment(last.TaskInfo.startTime,'x').format('YYYY/MM/DD HH:mm') : '未知';
      }
      x.times = x.calledInfo.length;
      return x;
    });
  },
  getConsumersLoading() {
    return state.numbersLoading;
  },
  allLoaded() {
    return state.numbers.length == state.page.total;
  },
  allCalledLoaded() {
    return state.calledNumbers.length == state.pageCalled.total;
  },
  getPage() {
    return state.page;
  },
  getPageCalled() {
    return state.pageCalled;
  }
};

const actions = {
  [types.GET_RECOGNITIONS]({ commit }, {  sessionID, skip = 0, limit = 50, date, refresh = false, called =false, callback }) {
    commit(types.NUMBERS_LOADING, true);
    fetch(`/v2/api/recognitions?sessionID=${sessionID}&skip=${skip}&limit=${limit}&date=${date}&called=${called}`, {
    }).then((res) => {
      if (res.ok) {
        return res.json();
      }
      return Promise.reject(res.status);
    }).then((data) => {
      callback();
      commit(types.NUMBERS_LOADING, false);
      commit(types.GET_NUMBERS, _.merge(data,{ refresh, called: (!called || called == false ? false : true) }));
    }).catch((err) => {
      commit(types.NUMBERS_LOADING, false);
      callback(err);
    });
  },
  [types.CALL_BEGIN]({ commit }, { slotID, pubID, unikey, phone, expiration= 30*60, callback }) {
   fetch('/v2/api/job/call', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json;charset=UTF-8',
      },
      timeout: 300000,
      body: JSON.stringify({ slotID, pubID, unikey, phone, expiration }),
    }).then(async (res) => {
      if (res.ok) {
        return res.json();
      }
      return Promise.reject(await res.json());
    }).then((data) => {
      callback(null, data);
    }).catch((data) => {
      callback(data.error ? data.error : '未知错误');
    });
  },
};

const mutations = {
  [types.GET_NUMBERS](state, data) {
    data.recognitions = data.recognitions.map(x => {
      x.updateTimestamp = moment(x.updateTimestamp,'x').format('YYYY/MM/DD HH:mm');
      if( x.updateCalledTimestamp )
        x.updateCalledTimestamp = moment(x.updateCalledTimestamp,'x').format('YYYY/MM/DD HH:mm');
      return x;
    });
    if(data.called) {
      state.pageCalled = _.cloneDeep(data.page);
      state.calledNumbers = (data.refresh ?  data.recognitions : data.recognitions.concat(state.calledNumbers));
    } else {
      state.page =  _.cloneDeep(data.page);
      state.numbers = (data.refresh ?  data.recognitions : data.recognitions.concat(state.numbers));
    }
  },
  [types.NUMBERS_LOADING](state, loading) {
    state.numbersLoading = loading;
  },
};

export default {
  state,
  getters,
  actions,
  mutations,
};

