/* eslint-disable */
import moment from 'moment';
const statusArray = ['定时任务时间已过', '审核未通过', '其他错误', '准备发送', '审核中', '审核通过准备发送', '正在发送', '发送完成'];
const types = {
  SEND_JOB: 'SEND_JOB',
  GET_JOBS: 'GET_JOBS',
  JOB_LOADING: 'JOB_LOADING',
};
const state = {
  jobs: [],
  jobLoading: false,
  createdJob: null,
};

const getters = {
  getJobs(state) {
    return state.jobs;
  },
  getJobsLoading(state) {
    return state.jobLoading;
  },
};

const actions = {
   [types.SEND_JOB]({ commit }, {  templateId, unikeyArray, sendTime, accountID, callback }) {
    fetch('/v2/api/job/msg', { //短信任务
      method: 'POST',
      headers: {
        'Content-Type': 'application/json;charset=UTF-8',
      },
      body: JSON.stringify({ templateId, unikeyArray, sendTime, accountID }),
    }).then((res) => {
      if (res.ok) {
        return res.json();
      }
      return Promise.reject(res.status);
    }).then((data) => {
      commit(types.SEND_JOB, data || []);
      callback(null, data);
    }).catch((err) => {
      callback(err);
    });
  },
  [types.GET_JOBS]({ commit }, {  accountID, skip = 0, limit = 50, callback, page }) {
    commit(types.JOB_LOADING, true);
    fetch(`/v2/api/jobs?accountID=${accountID}&skip=${skip}&limit=${limit}`).then((res) => { //短信任务获取
      if (res.ok) {
        return res.json();
      }
      return Promise.reject(res.status);
    }).then((data) => {
      console.dir(' in jobs');
      if(page) {
        page({
          total: data.page.total,
          current: parseInt(data.page.skip, 10) + 1,
          size: data.page.limit,
        });
      }
      data.jobs.map( x => { 
        const statusInfo = statusArray[ parseInt(x.status) + 2 ];
        const time = moment(x.startTimestamp,'x').format('YYYY-MM-DD HH:mm');
        return _.merge(x,{ time, statusInfo }) 
      });
      commit(types.GET_JOBS, data.jobs);
      commit(types.JOB_LOADING, false);
    }).catch((err) => {
      console.log(err);
      commit(types.JOB_LOADING, false);
    });
  },
};

const mutations = {
  [types.SEND_JOB](state, data) {
    state.createdJob = data;
  },
  [types.GET_JOBS](state, data) {
    state.jobs = data;
  },
  [types.JOB_LOADING](state, loading) {
    state.jobLoading = loading;
  },
};

export default {
  state,
  getters,
  actions,
  mutations,
};