const router = require("express").Router();
const mongodb = require("mongodb");
const MongoClient = mongodb.MongoClient;
const crypto = require("crypto");
const axios = require("axios");
const _ = require("lodash");
const moment = require('moment');
const adminID = process.env.NODE_ENV === 'production' ? '5a9f9e6b46da1176a40e1082' : '5ab083b1f6134d82b40d95f2';
let db = {};
let oem_db = { mtty:{}, xibao:{} };
const dbpath = process.env.MONGO || "mongodb://10.11.3.127:1301/remarketing";

const oem_dbpath = ( process.env.MONGO_OEM + process.env.MONGO_DB_MTTY  || "mongodb://10.11.3.127:1301/remarketing" ) + (process.env.MONGO_OEM  ?  "?replicaSet=bjwjh-rs&authSource=admin" : '');
//const xibao_dbpath = process.env.MONGO_OEM +process.env.MONGO_DB_XIBAO + "?replicaSet=bjwjh-rs&authSource=admin";


const salt = ",tom";
const EXPIRATION = 60 * 30;
// TODO ! put into init
MongoClient.connect(dbpath, (err, conn) => {
  if (err) return console.log(err);
  console.log("#### DB CONNECTED");
  db = conn.db("remarketing");
  db
    .collection("tokenSession")
    .createIndex({ createdAt: 1 }, { expireAfterSeconds: 3600 * 24 });
});


MongoClient.connect(oem_dbpath, (err, conn) => {
  if (err) return console.log(err);
  console.log("#### OEM DB CONNECTED");
  oem_db.mtty = conn.db(process.env.MONGO_DB_MTTY);
  oem_db.xibao = conn.db(process.env.MONGO_DB_XIBAO);
  oem_db.mtty
    .collection("tokenSession")
    .createIndex({ createdAt: 1 }, { expireAfterSeconds: 3600 * 24 });
   oem_db.xibao
    .collection("tokenSession")
    .createIndex({ createdAt: 1 }, { expireAfterSeconds: 3600 * 24 });
});

/*router.post('/remark',function (req,res) {
  const { recog, remark, unikey, sessionID } = req.body;
  let data = _.merge(req.query,req.body);
  checkSession(data, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let db = getDB(rep);
      let doc = { recog, remark, unikey };
      if(doc.recog) delete doc.unikey;
      if(doc.unikey) delete doc.recog;
      const host = getHost(rep) + "/remark";
      axios(host, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        data: doc,
        timeout: 300000
      })
      .then(async rep => {
         res.send({ status:'ok', data: rep.data });
      })
      .catch(err => {
          console.dir(err);
          if (err) return  res.status(500).json({ error: '服务出错'});
      });
    }});
});*/



router.post('/remark',function (req,res) {
  const { recog, tags, remark, sessionID } = req.body;
  const type = req.query.type;
  checkSession(req.body, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let db = getDB(rep);
      let collectionName = ((type === 'dsp') ? 'dspRecognition' : 'recognition');
      let _tags = Array.isArray(tags) ? tags : [tags];
      db.collection(collectionName).update({ _id: OID(recog) },{ $set: { systemTags: _tags  }, $push: { remark: remark } }, (err, rep) => {
        if(err) res.status(500).json({ error: '服务出错'});
        else res.send({ status: 'ok',rep });
      });
    }});
});


router.get('/tags',function (req,res) {
  checkSession(req.query, async (err, rep) => {
    if (err || !rep || !rep.tokenID) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
        let db = getDB(rep);
        let token = await db.collection('tokens').findOne({_id: OID(rep.tokenID)});
        let accountID = token ? token.accountID : null;
        let dspGroupIds = await db.collection('dspRecognition').distinct('groupID',{'tokenInfo.tokenID': OID(rep.tokenID) });
        let slotIds = await db.collection('recognition').distinct('slotID',{'tokenInfo.tokenID': OID(rep.tokenID) });
        let dspGroups = dspGroupIds.length ? await db.collection('dspCallGroups').find({ _id: { $in: dspGroupIds} }, { dspgroup : 1 }).toArray() : [];
        dspGroups = dspGroups.map( x => { return { _id: x._id, name: x.dspgroup } });
        slotIds = slotIds.map( x => OID(x));
        let slots = slotIds.length ? await db.collection('slotTemps').find({ _id: { $in: slotIds } },{ slotName: 1 }).toArray() : [];
        slots = slots.map( x => { return { _id: x._id, name: x.slotName } });
        console.dir({ accountID,status:true });
        let tags = await db.collection('tags').find({ accountID,status:true }).limit(10).sort({ createdAt:-1 }).toArray();
        tags = tags.map( x => x.tag );
        res.send({ status:'ok',callstatus: ['已拨打','未拨打'], tags: tags.length ? tags : ['有意向','已经加微信','需回拨','未接通','无意向'], dspGroups, slots });
    }
 })
})


router.post('/job/call',function (req,res) {
  const { pubID, slotID, phone, expiration = EXPIRATION, unikey, sessionID } = req.body;
  let data = _.merge(req.query,req.body);
  checkSession(data, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
        let db = getDB(rep);
        let _host = getHost(rep);
        getCallConsume( db, 'call', (err, data) => {
          if(err) return res.status(500).json({ error: err});
          if(data && data.number) {
            checkBill({ accountID: pubID, number: data.number }, db, async (_err) => {
              if(_err) {
                return res.status(500).json({ error: _err});
              } else {
                if(!notEmpty(req.body)) res.status(500).json({ error: "参数错误"});
                else {
                  const fromID = await getFromID(pubID,db);
                  const host = _host + "/bind/" + (pubID + "_" + fromID)  + '/' + slotID + '?caller=' + phone + '&unikey=' + unikey + '&expiration=' + expiration;
                  axios(host, {
                    method: "GET",
                    headers: { "Content-Type": "application/json" },
                    timeout: 300000
                  })
                  .then(async rep => {
                    if(rep.data &&  rep.data.called && rep.data._id && rep.data.bindID){
                      //const fromID = await getFromID(pubID);
                      updateBill({pre: true, number: data.number, accountID: pubID, fromID, type: 'call', taskID: rep.data._id}, db, (err,_rep) => {
                        if(err) {
                          // log 代码；
                        }
                        res.send({ status: 'ok', called: rep.data.called, bindID: rep.data.bindID });
                      });
                    }
                    else{
                      res.status(500).json({ error: '取号失败'});
                    }
                  })
                  .catch(err => {
                    console.dir(err)
                    if (err) return  res.status(500).json({ error: '运营商拒绝服务'});
                  });
                }
              }
            });
          } else {
              res.status(500);
          }
        });
  }});
});

// 电信绑定
router.post('/job/tycall',function (req,res) {
  const { pubID, groupID, phone, expiration = EXPIRATION, unikey } = req.body;
  let data = _.merge(req.query,req.body);
  checkSession(data, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let db = getDB(rep);
      let _host = getHost(rep);
      getCallConsume(db, 'tycall', (err, data) => {
      if(err) return res.status(500).json({ error: err});
      if(data && data.number) {
        checkBill({ accountID: pubID, number: data.number },db, async (_err) => {
          if(_err) {
            return res.status(500).json({ error: _err});
          } else {
            if(!notEmpty(req.body)) res.status(500).json({ error: "参数错误"});
            else {
              const fromID = await getFromID(pubID,db);
              const host = _host + "/ty/bind/" + (pubID + "_" + fromID)  + '/' + groupID + '?caller=' + phone + '&unikey=' + unikey + '&expiration=' + expiration;
              axios(host, {
                method: "GET",
                headers: { "Content-Type": "application/json" },
                timeout: 300000
              })
              .then(async rep => {
                if(rep.data &&  rep.data.called && rep.data._id){
                  //const fromID = await getFromID(pubID);
                  updateBill({pre: true, number: data.number, accountID: pubID, fromID, type: 'tycall', groupID, taskID: rep.data._id }, db, (err,_rep) => {
                    console.dir('in callback');
                    if(err) {
                      // log 代码；
                      console.dir(err);
                    }
                    console.dir(rep);
                    res.send({ status: 'ok', called: rep.data.called, caller: phone, unikey });
                  });
                }
                else{
                  res.status(500).json({ error: '取号失败'});
                }
              })
              .catch(err => {
                console.dir(err)
                if (err) return  res.status(500).json({ error: '运营商拒绝服务'});
              });
            }
          }
        });
      } else {
          res.status(500);
      }
      });
    }
  });

});


router.post('/job/dspcall',function (req,res) {
  const { pubID, groupID, phone, expiration = EXPIRATION, unikey } = req.body;
  let data = _.merge(req.query,req.body);
  checkSession(data, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let db = getDB(rep);
      let _host = getHost(rep);
      getCallConsume( db, 'call', (err, data) => {
      if(err) return res.status(500).json({ error: err});
      if(data && data.number) {
        checkBill({ accountID: pubID, number: data.number },db, async (_err) => {
          if(_err) {
            return res.status(500).json({ error: _err});
          } else {
            if(!notEmpty(req.body)) res.status(500).json({ error: "参数错误"});
            else {
              const fromID = await getFromID(pubID,db);
              const host = _host + "/dspBind/" + (pubID + "_" + fromID)  + '/' + groupID + '?caller=' + phone + '&unikey=' + unikey + '&expiration=' + expiration;
              axios(host, {
                method: "GET",
                headers: { "Content-Type": "application/json" },
                timeout: 300000
              })
              .then(async rep => {
                if(rep.data &&  rep.data.called && rep.data._id && rep.data.bindID){
                  //const fromID = await getFromID(pubID);
                  updateBill({pre: true, number: data.number, accountID: pubID, fromID, type: 'dspcall', groupID,taskID: rep.data._id }, db, (err,_rep) => {
                    if(err) {
                      // log 代码；
                    }
                    res.send({ status: 'ok', called: rep.data.called, bindID: rep.data.bindID });
                  });
                }
                else{
                  res.status(500).json({ error: '取号失败'});
                }
              })
              .catch(err => {
                console.dir(err)
                if (err) return  res.status(500).json({ error: '运营商拒绝服务'});
              });
            }
          }
        });
      } else {
          res.status(500);
      }
      });
    }
  });

});

router.get('/unbind',function (req,res) {
  let data = _.merge(req.query,req.body);
  checkSession(data, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let _host = getHost(rep);
      const { bindID } = req.query;
      const host = _host + "/unbind?bindID=" + bindID;
      axios(host, {
        method: "GET",
        headers: { "Content-Type": "application/json" },
        timeout: 300000
      })
      .then(rep => {
        res.send({status:'ok'});
      })
      .catch(err => {
        console.dir(err);
        if (err) return res.status(500).json({ error: '解绑错误'});
      });

    }
  })

});

// 电信解绑
router.get('/ty/unbind',function (req,res) {
  let data = _.merge(req.query,req.body);
  checkSession(data, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let _host = getHost(rep);
      const { caller, called, unikey } = req.query;
      const host = _host + "/ty/unbind?caller=" + caller + '&called=' + called + '&unikey=' + unikey;
      axios(host, {
        method: "GET",
        headers: { "Content-Type": "application/json" },
        timeout: 300000
      })
      .then(rep => {
        res.send({ status:'ok' });
      })
      .catch(err => {
        console.dir(err);
        if (err) return res.status(500).json({ error: '解绑错误' });
      });
    }
  })
});

router.get('/dspUnbind',function (req,res) {
  let data = _.merge(req.query,req.body);
  checkSession(data, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let _host = getHost(rep);
      const { bindID } = req.query;
      const host = _host + "/dspUnbind?bindID=" + bindID;
      axios(host, {
        method: "GET",
        headers: { "Content-Type": "application/json" },
        timeout: 300000
      })
      .then(rep => {
        res.send({status:'ok'});
      })
      .catch(err => {
        if (err) return res.status(500).json({ error: '解绑错误'});
      });
    }
  });
});

router.get('/stats',function (req,res) {
  let data = _.merge(req.query,req.body);
  checkSession(data, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let db = getDB(rep);
      let { phone } = await db
        .collection("tokens")
        .findOne({ _id: OID(rep.tokenID) })
      if(!phone) return res.status(500).json({ error: "账号错误,重新登录", code: 302 });
      let date = new Date();
      let weekday = date.getDay() || 7;
      date.setDate(date.getDate()-weekday+1);
      let start =  moment(date).format('YYYYMMDD');
      let end = moment().format('YYYYMMDD');
      let statistics = {};
      let stats = await db
                      .collection('callTask')
                      .aggregate([
                      {
                        $match:{
                          "caller" : phone,
                          "date": { $gte: start, $lte: end },
                        }
                      },
                      {
                        $group:{
                          _id: {
                            date: "$date",
                          },
                          duration: { $sum:"$duration" },
                          count: { $sum: 1 }
                        }
                      }]).toArray();
      let dspstats = await db
                      .collection('dspCallTask')
                      .aggregate([
                      {
                        $match:{
                          "caller" : phone,
                          "date": { $gte: start, $lte: end },
                        }
                      },
                      {
                        $group:{
                          _id: {
                            date: "$date",
                          },
                          duration: {$sum:"$duration"},
                          count: { $sum: 1 }
                        }
                      }]).toArray();

    let duration_stats = await db
                      .collection('callTask')
                      .aggregate([
                      {
                        $match:{
                          "caller" : phone,
                          "date": { $gte: start, $lte: end },
                          "duration": { $gt: 0 }
                        }
                      },
                      {
                        $group:{
                          _id: {
                            date: "$date",
                          },
                          count: { $sum: 1 }
                        }
                      }]).toArray();
      let dsp_duration_stats = await db
                      .collection('dspCallTask')
                      .aggregate([
                      {
                        $match:{
                          "caller" : phone,
                          "date": { $gte: start, $lte: end },
                          "duration": { $gt: 0 }
                        }
                      },
                      {
                        $group:{
                          _id: {
                            date: "$date",
                          },
                          count: { $sum: 1 }
                        }
                      }]).toArray();
    let _stats = stats.concat(dspstats);

    let _duration_stats = duration_stats.concat(dsp_duration_stats);
    _stats.forEach( x => {
      let date = x._id.date || 'unknown';
      if(statistics[date]) {
          statistics[date].count += x.count;
          statistics[date].duration += x.duration;
          statistics[date].pinged = 0;
      } else {
        statistics[date] = {
          count: x.count,
          duration: x.duration,
          pinged: 0,
        }
      }
    });
    _duration_stats.forEach( x => {
      let date = x._id.date || 'unknown';
      if(statistics[date] && statistics[date].pinged) {
          statistics[date].pinged += ( x.count || 0);
      } else {
        statistics[date].pinged = x.count || 0;
      }
      });
      res.send({ status:'ok', statistics  });
    }
  });
});

router.post('/login',async function (req,res) {
  //token phone sessionID
  checkSession(req.body, (err, rep) => {
    if (err) return res.status(500).json({ error: "查询失败" });
    if (!rep) {
      //没有符合的session
      return authorize(req.body, (err, rep) => {
        console.dir(err);
        if (err) return res.status(500).json({ error: "查询账户失败" });
        if (!rep) return res.status(403).json({ error: "账户不存在" });
        //验证通过
        const token = _.merge(rep, { sessionID: genSessionID(rep._id, rep.db) });
        delete token.token;
        res.send({ status: "ok", token });
      });
    } else {
      let db = getDB(rep);
      db
        .collection("tokens")
        .findOne({ _id: OID(rep.tokenID) }, (err, rep) => {
          if (err || !rep) return res.status(500).json({ error: "查询账户失败"});
          const token = _.merge(rep, { sessionID: req.body.sessionID });
          delete token.token;
          delete token.passwd;
          res.send({ status: "ok", token });
        });
    }
  });
});

router.post("/logout",function(req,res) {
  let { sessionID } = req.body;
  db
    .collection('tokenSession')
    .remove({ _id: OID(sessionID) }, (err, rep) => {
      if (err || !rep) return res.status(500).json({ error: "更新session新失败"});
      res.send({ status: "ok", rep });
    });
});

router.post("/recognitions",function(req,res) {
  let { sessionID, limit = 10, skip = 0, called , tags , slots, carrier } = req.body;
  checkSession(req.body, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let db = getDB(rep);
      const tokenID = rep.tokenID;
      let sort = {};
      let qs = {};
      if( tags && tags.length) {
        let _tags = Array.isArray(tags) ? tags : [ tags ];
        qs.systemTags = { $in: _tags };
      }
      if( slots && slots.length ) {
        let _slots = Array.isArray(slots) ? slots : [ slots ];
        qs.slotID = { $in: slots };
      }
      if( called === 'true' ||  called === true || called === 'false' ||  called === false  ) {
        qs['calledInfo'] = { $exists: called === 'true' ||  called === true }
      }
      if(carrier) {
        if(carrier === 'cucc') {
          qs.carrier = { $nin: ['ctcc','cmcc'] }
        } else
          qs.carrier = carrier;
      } 
      _.merge(qs,  { 'tokenInfo.tokenID': OID(tokenID) , auditStatus: 2 } );
      if(called === 'true' || called === true ) sort.calledTimestamp = -1;
      else sort.updateTimestamp = -1;
      const count = await db.collection('recognition').count(qs);
      db
        .collection('recognition')
        .find(qs)
        .sort(sort)
        .skip(parseInt(skip * limit))
        .limit(parseInt(limit))
        .toArray(async (err, rep) => {
            if (err) return res.status(500).json({ error: "数据查询失败" });
            //const arrs = await getStars(rep);
            let _arrs = await getSlots(rep,db);
            if(called == 'true') _arrs = await getTasks(_arrs,db);
            res.send({ status: "ok", recognitions: _arrs, page: { skip: skip, total: count } })
        });
    }
  });
});

router.post("/dsprecognitions",function(req,res) {
  let { sessionID, limit = 10, skip = 0,  called, tags, groups, carrier } = req.body;
  checkSession(req.body, async (err, rep) => {
    if (err || !rep) return res.status(500).json({ error: "session错误,重新登录", code: 302 });
    else {
      let db = getDB(rep);
      const tokenID = rep.tokenID;
      let sort = {};
      let qs = {}
      if( tags && tags.length) {
        let _tags = Array.isArray(tags) ? tags : [ tags ];
        qs.systemTags = { $in: _tags };
      }
      if( groups && groups.length ) {
        let _groups = Array.isArray(groups) ? groups : [ groups ];
        _groups = _groups.map( x => OID(x) );
        qs.groupID = { $in: _groups };
      }
      if( called === 'true' ||  called === true || called === 'false' ||  called === false  ) {
        qs['calledInfo'] = { $exists: called === 'true' ||  called === true }
      }
      _.merge(qs,  { 'tokenInfo.tokenID': OID(tokenID) } );
      if(called === 'true' || called === true) sort.calledTimestamp = -1;
      else sort.createdAt = -1;
      if(carrier) {
        if(carrier === 'cucc') {
          qs.carrier = { $nin: ['ctcc','cmcc'] }
        } else
          qs.carrier = carrier;
      }

      const count = await db.collection('dspRecognition').count(qs);
      db
        .collection('dspRecognition')
        .find(qs,{ tags:0 })
        .sort(sort)
        .skip(parseInt(skip * limit))
        .limit(parseInt(limit))
        .toArray(async (err, rep) => {
            if (err) return res.status(500).json({ error: "数据查询失败" });
            let _arrs = await getCallGroupInfo(rep, db);
            res.send({ status: "ok", recognitions: _arrs, page: { skip: skip, total: count } })
        });
    }
  });
});


async function getCallGroupInfo(arrays,_db) {
    let tasks = [];
    arrays.forEach((x) => {
        tasks.push(new Promise(async (r,e) => {
          const GroupInfo = (x.groupID && exists(x.groupID)) ? await _db
            .collection("dspCallGroups")
            .findOne({ _id: OID(x.groupID) },{dspgroup: 1}) : { dspgroup: '' };
            r(_.merge(x, { dspgroup: (GroupInfo ? GroupInfo.dspgroup : '') } ));   
        }));
    });
    const arrs = await Promise.all(tasks);
    return arrs;
}

async function getStars(arrays) {
    let tasks = [];
    arrays.forEach((x) => {
        tasks.push(new Promise(async (r,e) => {
          const score = x.slotID && x.pubID && x.unikey ? await db
            .collection("score")
            .findOne({ slotID: x.slotID , pubID: x.pubID, unikey: x.unikey },{ score: 1 }) : { score: -1 };
          r(_.merge(x,{ score: (score ? score : { score: -1 }) }));   
        }));
    });
    const arrs = await Promise.all(tasks);
    return arrs;
}

async function getSlots(arrays,_db) {
    let tasks = [];
    arrays.forEach((x) => {
        tasks.push(new Promise(async (r,e) => {
          const slot = x['slotID'] ? await _db
            .collection("slotTemps")
            .findOne({ _id: OID(x.slotID), accountID: OID(x.pubID) },{ slotName: 1 }) : { slotName: '未知' };
          r(_.merge(x,{ slot: (slot ? slot : { slotName: '未知' }) }));   
        }));
    });
    const arrs = await Promise.all(tasks);
    return arrs;
}

function md5token(str) {
  const salt = ",tom";
  const hash = crypto
    .createHash("md5")
    .update(str + salt)
    .digest()
    .toString("hex");
  return hash;
}

function checkSession(data, callback) {
  if (!data.sessionID || !/^[0-9a-z]{24}$/.test(data.sessionID)) return callback(null);
  console.dir(data);
  db
    .collection("tokenSession")
    .findOne({ sessionID: OID(data.sessionID) }, (err, rep) => {
      console.dir(err)
      console.dir(rep)
      if (err || !rep) return callback(err, null);
      callback(null, rep);
    });
}


function exsists(ID) {
  return  ID !== undefined && ID !== null && ID !== 'all' &&  ID !== 'undefined';
}

function notEmpty(data) {
  let temp = true;
  Object.keys(data).forEach((key) => {
    temp = temp && data[key] && exsists(data[key]);
  })
  return temp;
}



async function authorize(data, callback) {
    let token = md5token(data.token);
    try {
      let self_user = await db.collection("tokens").findOne({ phone: data.phone, removed: { $ne: true } });
      let mtty_user = await oem_db.mtty.collection("tokens").findOne({ phone: data.phone, removed: { $ne: true }  });
      let xibao_user = await oem_db.xibao.collection("tokens").findOne({ phone: data.phone, removed: { $ne: true }  });
      if (self_user &&  self_user.passwd == token) {
        return callback(null, _.merge(self_user, {db: 'self'}));
      } 
      if ( mtty_user && mtty_user.passwd == token) {
        return callback(null, _.merge(mtty_user, {db: 'mtty'}));
      }
      if ( xibao_user && xibao_user.passwd == token) {
        return callback(null, _.merge(xibao_user, {db: 'xibao'}));
      } else {
        return callback(null, null);
      }
    } catch (err) {
      return callback(err, null);
    }
}

function genSessionID(tokenID,_db) {
  const sessionID = mongodb.ObjectID();
  db.collection("tokenSession").insert(
    {
      createdAt: new Date(),
      sessionID,
      tokenID,
      db:_db || 'self'
    },
    (err, rep) => {
      if (err) console.log(err);
    }
  );
  return sessionID;
}


async function checkBill(data, _db, callback) {
  if(!notEmpty(data)) return callback('参数错误');
  let { number, accountID } = data;
  if(!/^[0-9a-z]{24}$/.test(accountID) ) return callback('参数错误');
  let recharge = await getRechargeByAccount( accountID, _db );
  if( recharge <= 0 ) { return callback('余额不足') }
  let consume = await getBillByAccount( accountID , _db);
  if( consume + number > recharge ) { return callback('余额不足') }
  callback && callback();
}


async function updateBill(data, _db, callback) {

  if(!notEmpty(data)) return callback('params wrong');
  let { pre, number, accountID, type, taskID, fromID = 'self', groupID, preNum = 30 } = data;
  if(!/^[0-9a-z]{24}$/.test(accountID) ) return callback('params wrong');
  let _data = { pre, number, accountID: OID(accountID), fromID, type };
  if(groupID) {
    _data.groupID = OID(groupID);
  }
  _data.taskID =  OID(taskID);
  _db
    .collection('bills')
    .insert(wrapTime(_data,true), (err, rep) => {
      if (err) return callback(err);
      callback && callback(null, rep);
    });
}

async function getBillByAccount( accountID, _db ) {
  let consumes = await _db
                      .collection('bills')
                      .aggregate([
                      {
                        $match:{
                          "accountID": OID(accountID),
                          "removed": { $ne: true }
                       /* "createdAt": { '$gt': start, '$lte': end }*/
                        }
                      },
                      {
                        $group:{
                          _id: null,
                          sum: {$sum:"$number"}
                        }
                      }]).toArray();
  return ( (consumes && consumes.length) ?  consumes[0].sum  : 0 );               
}

async function getRechargeByAccount(accountID, _db) {
  let recharges =  await _db
                      .collection('recharge')
                      .aggregate([
                      {
                        $match:{
                          "accountID": OID(accountID),
                          "removed": { $ne: true } 
                        }
                      },
                      {
                        $group:{
                          _id:null,
                          sum:{$sum:"$number"}
                        }
                      }]).toArray();
  return ( (recharges && recharges.length) ?  recharges[0].sum  : 0 );
}

async function getCallConsume(_db,key,callback) {
  const price = _db.collection('price').findOne({type: key || 'call'});
  let defaultNum = { call: 1, tycall: 1.5 }
  let number = (price && price.number) ? price.number : (defaultNum[key] || 1);
  console.dir(number);
  //const task = db.collection('callTask').findOne({ unikey });
  callback(null, { number: Math.ceil((EXPIRATION / 60) ) * number });
}

async function getTasks(arrays,_db) {
    let _tasks = [];
    arrays.forEach((x) => {
      _tasks.push(new Promise(async (r,e) => {
        if(x.calledInfo && x.calledInfo.length) {
          let tasks = [];
          x.calledInfo.forEach((y) => {
              tasks.push(new Promise(async (r,e) => {
                const TaskInfo = (y.taskID && exsists(y.taskID)) ? await _db
                  .collection("callTask")
                  .findOne({ _id: OID(y.taskID) },{ startTime : 1 }) : { startTime: -1 };
                  r(_.merge( y, { TaskInfo } ));   
              }));
          });
          const arrs = await Promise.all(tasks);
          x.calledInfo = arrs;
        }
        r(x);
      }));
    });
    const _arr = await Promise.all(_tasks);
    return _arr;
}


function OID(str) {
  return  typeof str === 'string' ? mongodb.ObjectID(str) : str;
}

function wrapTime(obj, date) {
  let d = { createdAt: new Date() };
  if(date) {
    d.date = moment().format('YYYYMMDD');
  }
  return _.merge(obj,d )
}

function getDB(session) {
  if(session.db == 'mtty') return oem_db.mtty;
  if(session.db == 'xibao') return oem_db.xibao;
  else return db;
}

function getHost(session) {
  if(session.db == 'mtty') return 'http://remarkering-mtty-yh.yoo.yunpro.cn';
  if(session.db == 'xibao') return 'http://remarketing-xibao-yh.yoo.yunpro.cn';
  else return 'http://remarketing-job-yh.yoo.yunpro.cn';
}

async function getFromID(accountID,_db) {
  const account = await _db.collection('account').findOne({ _id: OID(accountID) });
  return  (account && account.fromID  ? account.fromID : 'self');
}

function getTimeRange({ start, end, type, key}) {
  if(/^[0-9]{8}$/.test(start) && /^[0-9]{8}$/.test(end) ) {
     if(type === 'millisecond') {
     return { [ key ]: { '$gt': parseInt(moment(start,'YYYYMMDD').startOf('day').format('x')), '$lte': parseInt(moment(end,'YYYYMMDD').endOf('day').format('x')) } };
    } else {
     return { [ key ]: { '$gt': moment(start,'YYYYMMDD').startOf('day').toDate(), '$lte': moment(end,'YYYYMMDD').endOf('day').toDate() } };
    }
  } else {
    if(type === 'millisecond') {
     return { [ key ]: { '$gt': parseInt(moment().add(-7,'days').startOf('day').format('x')), '$lte': parseInt(moment().endOf('day').format('x')) } };
    } else {
     return { [ key ]: { '$gt': moment().add(-7,'days').startOf('day').toDate(), '$lte': moment().endOf('day').toDate() } };
    }
  }
}
function exists(ID) {
  return  ID !== undefined && ID !== null && ID !== 'null' && ID !== '' && ID !== 'all' &&  ID !== 'undefined';
}

module.exports = router;
