// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import 'font-awesome-webpack';
import Vue from 'vue';
import Mint from 'mint-ui';
import 'mint-ui/lib/style.min.css';
import store from './store';
import App from './App';
import router from './router';


Vue.config.productionTip = false;
Vue.use(Mint);
// check session
store.dispatch('login', {
  sessionID: localStorage.getItem('__sessionID'),
  callback(err) {
    if (err) console.log(err);
    router.beforeEach((to, from, next) => {
      if (to.matched.some(record => record.meta.requiresAuth)) {
        // this route requires auth, check if logged in
        // if not, redirect to login page.
        if (!store.state.session.authed) {
          next({ path: '/login', query: { redirect: to.fullPath } });
        } else {
          console.log(to, from);
          next();
        }
      } else {
        console.log(to, from);
        if (to.path === '/login' && store.state.session.authed) {
          next({ path: '/' });
        } else {
          next(); // 确保一定要调用 next()
        }
      }
    });
    /* eslint-disable no-new */
    new Vue({
      el: '#app',
      router,
      store,
      components: {
        App,
      },
      template: '<App/>',
    });
  },
});
