const _ = require("lodash");
const foo = [
  { uid: 1, unikey: null, time: 1 },
  { uid: 2, unikey: null, time: 2 },
  { uid: 3, unikey: 1, time: 3 },
  { uid: 4, unikey: 1, time: 4 },
  { uid: 5, unikey: 2, time: 5 }
];

function formatNumbers(numbers) {
  return _.chain(numbers)
  .map(item => {
    item.unikey = item.unikey ? item.unikey : item.uid;
    return item;
  })
  .orderBy('time', 'desc')
  .uniqBy('unikey')
  .value();
}

console.log(formatNumbers(foo));
