/* eslint-disable no-shadow */
const types = {
  LOGIN: 'LOGIN',
  CHANGE_USER: 'CHANGE_USER',
  CHECK_SESSION: 'CHECK_SESSION',
  DELETE_SESSION: 'DELETE_SESSION',
};

const state = {
  authed: false,
  currentUser: {
    email: 'test',
    id: '',
  },
  loginUser: {
    email: '',
    id: '',
    sessionID: '',
  },
};

const getters = {
  currentUser() {
    return state.currentUser;
  },
  loginUser() {
    return state.loginUser;
  },
  sessionID() {
    return localStorage.getItem('__sessionID');
  },
};

const actions = {
  login({ commit }, { phone, token, sessionID, callback }) {
    fetch('/api/login', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json;charset=UTF-8',
      },
      body: JSON.stringify({ phone, token, sessionID }),
    }).then((res) => {
      if (res.ok) {
        return res.json();
      }
      return Promise.reject(res.status);
    }).then((data) => {
      commit(types.LOGIN, data);
      callback(null, data);
    }).catch((err) => {
      console.log(err);
      callback(err);
    });
  },
  // check session when fresh
  session({ commit }, callback) {
    fetch('/api/session', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json;charset=UTF-8',
      },
      body: JSON.stringify({ sessionID: getters.sessionID() }),
    }).then((res) => {
      if (res.ok) {
        return res.json();
      }
      return Promise.reject(res.status);
    }).then((session) => {
      commit(types.CHECK_SESSION, session);
      callback(null, session);
    }).catch((err) => {
      console.log(err);
      callback(err);
    });
  },
  delSession({ commit }, callback) {
    fetch('/api/logout', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json;charset=UTF-8',
      },
      body: JSON.stringify({ sessionID: getters.sessionID() }),
    }).then((res) => {
      if (res.ok) {
        return res.json();
      }
      return Promise.reject(res.status);
    }).then((session) => {
      commit(types.DELETE_SESSION);
      callback(null, session);
    }).catch((err) => {
      console.log(err);
      callback(err);
    });
  },
};

const mutations = {
  [types.LOGIN](state, data) {
    const { token } = data;
    state.loginUser = token;
    state.currentUser = token;
    state.authed = true;
    localStorage.setItem('__sessionID', token.sessionID);
  },
  [types.CHECK_SESSION](state, data) {
    const { token } = data;
    state.loginUser = token;
    state.currentUser = token;
    state.authed = true;
    localStorage.setItem('__sessionID', token.sessionID);
  },
  [types.CHANGE_USER](state, { user, data }) {
    state.currentUser = user;
    localStorage.setItem('__sessionID', data.session.sessionID);
    location.href = '/';
  },
  [types.DELETE_SESSION](state) {
    state.loginUser = {};
    state.authed = false;
    localStorage.removeItem('__sessionID');
    location.href = '/';
  },
};

export default {
  state,
  getters,
  actions,
  mutations,
};
