import Vue from 'vue';
import Router from 'vue-router';

const Main = () => import('@/components/Main');
const NotFound = () => import('@/components/NotFound');
const Login = () => import('@/components/Login');
const ToDo = () => import('@/components/Todo');

Vue.use(Router);

export default new Router({
  routes: [
    {
      path: '/',
      component: Main,
      meta: { requiresAuth: process.env.NODE_ENV !== 'development' },
      children: [
        { name: 'TelJob', path: '/jobs/tel', component: ToDo },
      ],
    },
    {
      path: '/login',
      meta: { requiresAuth: false },
      component: Login,
    },
    {
      path: '*',
      meta: { requiresAuth: false },
      component: NotFound,
    },
  ],
});
