const router = require("express").Router();
const mongodb = require("mongodb");
const MongoClient = mongodb.MongoClient;
const crypto = require("crypto");
const axios = require("axios");
const _ = require("lodash");
const moment = require('moment');
const adminID = process.env.NODE_ENV === 'production' ? '5a9f9e6b46da1176a40e1082' : '5ab083b1f6134d82b40d95f2';

let db = {};
const dbpath = process.env.MONGO || "mongodb://localhost:27017/remarketing";
const salt = ",tom";
const EXPIRATION = 60 * 30;
// TODO ! put into init
MongoClient.connect(dbpath, (err, conn) => {
  if (err) return console.log(err);
  console.log("#### DB CONNECTED");
  db = conn.db("remarketing");
  db
    .collection("tokenSession")
    .createIndex({ createdAt: 1 }, { expireAfterSeconds: 3600 * 24 });
});

router.post('/job/call',function (req,res) {
  const { pubID, slotID, phone, expiration = EXPIRATION, unikey } = req.body;
  getCallConsumeByUnikey(unikey, (err, data) => {
  if(err) res.status(500).json({ error: err});
  if(data && data.number) {
    console.dir(data)
    checkBill({ accountID: pubID, number: data.number },(_err) => {
      if(_err) {
        return res.status(500).json({ error: _err});
      } else {
        if(!notEmpty(req.body)) res.sendStatus(500);
        else {
          const host = "http://remarketing-job-yh.yoo.yunpro.cn/bind/" + pubID + '/' + slotID + '?caller=' + phone + '&unikey=' + unikey + '&expiration=' + expiration;
          axios(host, {
            method: "GET",
            headers: { "Content-Type": "application/json" },
            timeout: 300000
          })
          .then(rep => {
            console.dir(rep.data);
            if(rep.data && rep.data.called && rep.data._id){
              updateBill({pre: true, number: data.number, accountID: pubID, type: 'call', taskID: rep.data._id}, (err,_rep) => {
                if(err) {
                  // log 代码；
                }
                res.send({ status: 'ok', called: rep.data.called })
              });
            }
            else{
              res.status(500).json({ error: '取号失败'});
            }
          })
          .catch(err => {
            if (err) return res.sendStatus(500);
          });
        }
      }
    });
  } else {
      res.status(500);
  }
  });
});

router.post('/login',async function (req,res) {
  //token phone sessionID
  checkSession(req.body, (err, rep) => {
    if (err) return res.sendStatus(500);
    if (!rep) {
      //没有符合的session
      return authorize(req.body, (err, rep) => {
        if (err) return res.sendStatus(500);
        if (!rep) return res.sendStatus(403);
        //验证通过
        const token = _.merge(rep, { sessionID: genSessionID(rep._id) });
        delete token.token;
        res.send({ status: "ok", token });
      });
    } else {
      db
        .collection("tokens")
        .findOne({ _id: OID(rep.tokenID) }, (err, rep) => {
          if (err || !rep) return res.sendStatus(500);
          const token = _.merge(rep, { sessionID: req.body.sessionID });
          delete token.token;
          delete token.passwd;
          res.send({ status: "ok", token });
        });
    }
  });
});

router.post("/logout",function(req,res) {
  let { sessionID } = req.body;
  db
    .collection('tokenSession')
    .remove({ _id: OID(sessionID) }, (err, rep) => {
      if (err || !rep) return res.sendStatus(500);
      res.send({ status: "ok", rep });
    });
});

router.get("/recognitions",function(req,res) {
  let { sessionID, limit = 10, skip = 0, date, called = 'false' } = req.query;
  checkSession(req.query, async (err, rep) => {
    if (err || !rep) return res.sendStatus(500);
    else {
      const tokenID = rep.tokenID;
      let qs = { updateTimestamp: { '$gt': parseInt(moment(date, 'YYYYMMDD').startOf('day').format('x')), '$lte': parseInt(moment(date, 'YYYYMMDD').endOf('day').format('x')) }, 'tokenInfo.tokenID': OID(tokenID) };
      _.merge(qs,  { calledInfo: { $exists: called == 'true' } } );
      const count = await db.collection('recognition').count(qs);
      db
        .collection('recognition')
        .find(qs)
        .sort({ updateTimestamp: -1 })
        .skip(parseInt(skip * limit))
        .limit(parseInt(limit))
        .toArray(async (err, rep) => {
            if (err) return res.sendStatus(500);
            const arrs = await getStars(rep);
            const _arrs = await getSlots(arrs);
            res.send({ status: "ok", recognitions: _arrs, page: { skip: skip, total: count } })
        });
    }
  });
});


async function getStars(arrays) {
    let tasks = [];
    arrays.forEach((x) => {
        tasks.push(new Promise(async (r,e) => {
          const score = x.slotID && x.pubID && x.unikey ? await db
            .collection("score")
            .findOne({ slotID: x.slotID , pubID: x.pubID, unikey: x.unikey },{ score: 1 }) : { score: -1 };
          r(_.merge(x,{ score: (score ? score : { score: -1 }) }));   
        }));
    });
    const arrs = await Promise.all(tasks);
    return arrs;
}

async function getSlots(arrays) {
    let tasks = [];
    arrays.forEach((x) => {
        tasks.push(new Promise(async (r,e) => {
          const slot = x['slotID'] ? await db
            .collection("slotTemps")
            .findOne({ _id: OID(x.slotID), accountID: OID(x.pubID) },{ slotName: 1 }) : { slotName: '未知' };
          r(_.merge(x,{ slot: (slot ? slot : { slotName: '未知' }) }));   
        }));
    });
    const arrs = await Promise.all(tasks);
    return arrs;
}

function md5token(str) {
  const salt = ",tom";
  const hash = crypto
    .createHash("md5")
    .update(str + salt)
    .digest()
    .toString("hex");
  return hash;
}

function checkSession(data, callback) {
  if (!data.sessionID) return callback(null);
  db
    .collection("tokenSession")
    .findOne({ sessionID: OID(data.sessionID) }, (err, rep) => {
      if (err || !rep) return callback(err, null);
      callback(null, rep);
    });
}


function exsists(ID) {
  return  ID !== undefined && ID !== null && ID !== 'all' &&  ID !== 'undefined';
}

function notEmpty(data) {
  let temp = true;
  Object.keys(data).forEach((key) => {
    temp = temp && data[key] && exsists(data[key]);
  })
  return temp;
}



function authorize(data, callback) {
  db.collection("tokens").findOne({ phone: data.phone }, (err, rep) => {
    if (err || !rep) return callback(err, null);
    if (md5token(data.token) !== rep.passwd)
      return callback("password wrong", null);
    callback(null, rep);
  });
}

function genSessionID(tokenID) {
  const sessionID = mongodb.ObjectID();
  db.collection("tokenSession").insert(
    {
      createdAt: new Date(),
      sessionID,
      tokenID
    },
    (err, rep) => {
      if (err) console.log(err);
    }
  );
  return sessionID;
}


async function checkBill(data, callback) {
  if(!notEmpty(data)) return callback('参数错误');
  let { number, accountID } = data;
  if(!/^[0-9a-z]{24}$/.test(accountID) ) return callback('参数错误');
  let recharge = await getRechargeByAccount( accountID );
  if( recharge <= 0 ) { return callback('余额不足') }
  let consume = await getBillByAccount( accountID );
  if( consume + number > recharge ) { return callback('余额不足') }
  callback && callback();
}

async function updateBill(data, callback) {
  if(!notEmpty(data)) return callback('params wrong');
  let { pre, number, accountID, type, taskID } = data;
  if(!/^[0-9a-z]{24}$/.test(accountID) ) return callback('参数错误');
  db
    .collection('bills')
    .insert(wrapTime({ pre, number, accountID: OID(accountID), type, taskID: OID(taskID) }), (err, rep) => {
      if (err) return callback(err);
      callback && callback(null, rep);
    });
}

async function getBillByAccount( accountID ) {
  let consumes = await db
                      .collection('bills')
                      .aggregate([
                      {
                        $match:{
                          "accountID": OID(accountID),
                          "removed": { $ne: true }
                       /* "createdAt": { '$gt': start, '$lte': end }*/
                        }
                      },
                      {
                        $group:{
                          _id: null,
                          sum: {$sum:"$number"}
                        }
                      }]).toArray();
  return ( (consumes && consumes.length) ?  consumes[0].sum  : 0 );               
}

async function getRechargeByAccount(accountID) {
  let recharges =  await db
                      .collection('recharge')
                      .aggregate([
                      {
                        $match:{
                          "accountID": OID(accountID),
                          "removed": { $ne: true } 
                        }
                      },
                      {
                        $group:{
                          _id:null,
                          sum:{$sum:"$number"}
                        }
                      }]).toArray();
  return ( (recharges && recharges.length) ?  recharges[0].sum  : 0 );
}


async function getCallConsumeByUnikey(unikey,callback) {
  const price = db.collection('price').findOne({type: 'call'});
  let number = (price && price.number) ? price.number : 1;
  const task = db.collection('callTask').findOne({ unikey });
  if(!task) {
    callback(null, { number: 3 + Math.ceil((EXPIRATION / 60) -1) * number });
  } else {
    callback(null, { number: Math.ceil((EXPIRATION / 60) ) * number });
  }
}

function OID(str) {
  return  typeof str === 'string' ? mongodb.ObjectID(str) : str;
}

function wrapTime(obj) {
  return _.merge(obj, { createdAt: new Date() })
}

module.exports = router;
