var express = require('express');
var router = express.Router();
var generator = require('../lib/generator');
var hash = require('../util/hash');
var tao = require('../lib/tao');
var agent = require('../lib/tao-agent');
var kouling = require('../lib/tao-kouling');
var noneTkl = require('../lib/tao-nonetkl-log');
var click = require('../lib/tao-log-click');
var log = require('../lib/tao-log');
var mongoose = require('mongoose');
var config = require('../config/index');
var vipshop = require('../lib/vishop-log');
var moment = require('moment');
var request = require('request');
var fs = require('fs');
var _ = require('bluebird');
//var path = './';
var path = '/data/log/';
var map = {
  '5a338a6f88a4ac0012bb1939':"oYzDv947fx",
  '5a1bc9e10f36c60011fa4470':"wcFt5l23Ui",
  '5a24ccea53068a46fec01a8c':"Ei0XwL83yl",
  '5a27afd738f3c60012f3f4c3':"S6zJkI387K",
  '5a4b1b507edb1800127bec33':"xnIfbK03VD"
}

var redis = require("redis"),
    client = redis.createClient(config.redis);
_.promisifyAll(redis.RedisClient.prototype);
_.promisifyAll(redis.Multi.prototype);
client.on("error", function (err) {
    console.log("Error " + err);
});
/* GET home page. */
router.post('/agent', async function (req, res, next) {
   	let {user,password,role = 'channel'} = req.body;
   	if(!user || !password) res.status(400).send('params not full error');
   	else{
   		password = hash.create(password);
   		var u = await agent.findOne({user:user});
   		if(!u) 
   			tao.saveAgent({user,password,role},function(e,result){
   				res.send({status:'ok',result:result});
   			});
   		else 
   			res.status(400).send('already  exsits error');
   	}
});
router.post('/tb_kl', async function (req, res, next) {
  	let {info,creater,status = 'use'} = req.body;
   	if(!info || !creater) res.status(400).send('params not full error');
   	else{
   		var kl = await kouling.findOne({info:info});
   		creater = mongoose.Types.ObjectId(creater);
   		if(!kl) 
   			tao.saveKouling({info,creater,status},function(e,result){
   				res.send({status:'ok',result:result});
   			});
   		else 
   			res.status(400).send('already  exsits error');
   	}	 
});


router.get('/tb_kl', async function (req, res, next) {
  var ua = req.headers['user-agent'];
  var referer = req.headers['referer'];
	var options = {limit: 10000, skip: 0, sort: {}};
	var qd = req.query.qd;
  var ip =  req.headers['x-forwarded-for'] ||
            req.connection.remoteAddress ||
            req.socket.remoteAddress ||
            req.connection.socket.remoteAddress;
  var time = moment().add(8,'hours');
  var date = time.format('YYYYMMDD');
  var txt = time.format('YYYYMMDDHH') + '.log';
 
  fs.appendFile(path + txt,ip + '@' + qd + '@' + ua + '@' + referer+'\n',function(){
      console.log(ip + '@' + qd + '@' + ua + '@' + referer);
  });
  var qd_body = await agent.findById(qd);
  if(qd_body){
     //qd_body = qd_body.toJSON();
      if(qd_body.ipstatus == 'use'){
         var limit = qd_body.toJSON().iplimit || 0;
         var count = await client.getAsync(ip.split(':')[ip.split(':').length-1]);
         if(parseInt(count) >= limit){
              await noneTkl.update({date:date,qd:qd,iplimit:1},{'$inc':{times:1}},{upsert:true});
              return res.send('var cptext_tkl = "";');
         }
         else{
            let ipString = ip.split(':')[ip.split(':').length-1];
            let cache = await client.getAsync(ipString);
            if(cache){ 
              await client.incrAsync(ipString);
            }
            else{
              let exat = moment(date + '155959','YYYYMMDDHHmmss').format('x') - moment().format('x');
              exat = exat > 0 ? exat : 1;
              await client.setAsync(ipString,1,'PX',exat,'NX');
            }
         }
      }
      var kls = await kouling.find({creater:mongoose.Types.ObjectId(qd),status:'use'}, null, options);
      if(kls && kls.length){
        kls = kls.map(x => x.toJSON());
        var kl = kls[Math.floor(Math.random()*kls.length)];
        var k = 'var cptext_tkl = "';
        await log.update({key:kl.info,schedule:kl.schedule,link:kl.link,date:date},{'$inc':{times:1}},{upsert:true});
       /* if(map[qd])
          res.send(k + map[qd] + kl.info + '";');
        else*/
        res.send(k  +  kl.info + '";');
      }
      else{
        await noneTkl.update({date:date,qd:qd},{'$inc':{times:1}},{upsert:true});
        res.send('var cptext_tkl = "M8xFKz57eK";');
      }   
  }else{
    await noneTkl.update({date:date,qd:qd},{'$inc':{times:1}},{upsert:true});
    res.send('var cptext_tkl = "M8xFKz57eK";');
  }
});

router.get('/tb_kl/click', async function (req, res, next) {
  var qd = req.query.qd;
  var tkl = req.query.tkl;
  var date = moment().add(8,'hours').format('YYYYMMDD');
  if(qd) kls =  await click.update({date:date,qd:qd,info:tkl},{'$inc':{times:1}},{upsert:true});
    //await log.update({key:kl.info,schedule:kl.schedule,link:kl.link,date:date},{'$inc':{times:1}},{upsert:true});
  res.send({status:'ok'});
});


router.get('/all/tb_kl', async function (req, res, next) {
  var options = {limit: 10000, skip: 0, sort: {}};
  var qd = req.query.qd;
  var kls = [];
  if(qd) kls = await kouling.find({creater:mongoose.Types.ObjectId(qd),status:'use'}, null, options);
  kls = kls.map(x => x.toJSON().info);
    //await log.update({key:kl.info,schedule:kl.schedule,link:kl.link,date:date},{'$inc':{times:1}},{upsert:true});
  res.send({status:'ok',tkls:kls});
});

router.get('/log/tb_kl', async function (req, res, next) {
  try{
    var options = {limit: 1000, skip: 0, sort: {'updatedAt':-1}};
    var logs = await log.find({},null,options).populate('qd','user role');
    logs = logs.map(x => { var d = x.toJSON();d['updatedAt'] = moment(new Date(d['updatedAt']).getTime(),'x').format('YYYYMMDD HH:mm:ss');return d;});
    res.render('logs.ejs',{logs:logs});
  }catch(e){
    console.dir(e);
  }
});

router.get('/log/vipshop', async function (req, res, next) {
  try{
    console.log('in===');
    var key = req.query.key;
    await vipshop.update({key:key},{'$inc':{times:1}},{upsert:true});
    res.status(204).send("no content");
  }catch(e){
    console.dir(e);
  }
});

module.exports = router;
