var express = require('express');
var router = express.Router();
var hash = require('../util/hash');
var data = require('../lib/data');
var config = require('../config/index');
var article = require('../lib/tao-article');
var mongoose = require('mongoose');
/* GET home page. */
var flushMap = {
	"娱乐":{ people:['男','女'],industry:'娱乐传媒' },
	"健康":{ people:['男','女'],industry:'医疗保健' },
	"军事":{ people:['男'],industry:'' },
	"养生":{ people:['男','女'],industry:'医疗保健' },
	"情感":{ people:['男','女'],industry:'情色行业' },
	"宠物":{ people:['男','女'],industry:'' },
	"美食":{ people:['女'],industry:'餐饮业' },
	"汽车":{ people:['男'],industry:'汽车行业' },
	"社会":{ people:['男','女'],industry:'' },
	"体育":{ people:['男'],industry:'体育行业' },
	"科学":{ people:['男'],industry:'' },
	"旅游":{ people:['男','女'],industry:'旅游机构' },
	"历史":{ people:['男'],industry:'' },
	"生活":{ people:['女'],industry:'' }
}

router.get('/', function(req, res, next) {
  res.render('index', { title: 'Express' });
});
router.get('/direct/:contentId', function(req, res, next) {
	var uid = req.cookies && req.cookies['uid'];
	var id = req.params.contentId;
 	data.getContentById(id,function(err,result){

		if(err) callback(err);
		if(result && result['data'] && result['data']['content'] && result['data']['content']['content'])
		var millis = result['data']['content']['updateAt'];
		var date = new Date(millis);
		//console.dir(date.getFullYear() +'-'+ Date(millis).getUTCMonth()+'-'+Date(millis).getUTCMinutes());
		var data = {
			title:result['data']['content']['title'],
			content:result['data']['content']['content'],
			time: millis ? (date.getFullYear() +'-'+ date.getUTCMonth()+'-'+date.getUTCDay()) : '',
			category:result['data']['content']['category'],
			industry:(flushMap[ result['data']['content']['category'] ]|| {} )['industry']
		}
		if(!uid) res.cookie('uid',hash.create((new Date()).getTime()),{ expires: new Date(Date.now() + 900000000000) });
		res.render('template/content',data)
		//createHtml(path+'.html',content,data,callback);
	});

});
router.get('/good/:goodId', async function(req, res, next) {
	try{
		var data = await article.findById(req.params.goodId);
		res.render('template/good',data.toJSON());
	}catch(err){
		console.dir(err)
	}

});

router.get('/log',function(req,res,next){
	var q = req.query;
	data.logES(q,function(error,body){
		console.dir(error);
		console.dir(body);
	});


});

module.exports = router;