var hash = require('../util/hash');
var config = require('../config/index');
var Agent = require('../lib/tao-agent');
var Kouling = require('../lib/tao-kouling');
var mongoose = require('mongoose');

exports.getKoulings = function(query,cb) {
	var koulings =  [];
	Kouling.find(query).populate('tao-agent').exec(function(err,koulings){
		if(err) console.dir(err);
		console.dir(koulings);
	});
};

exports.saveKouling = async function(data,cb) {
	try {
		var kouling = new Kouling(data);
		cb(null,await kouling.save());
	} catch(e){
		cb(e);
	}
}

exports.saveAgent = async function(data,cb) {
	try {
		var agent = new Agent(data);
		cb(null,await agent.save())
	} catch(e){
		cb(e);
	}
}


exports.findAgent = async function(qs,cb) {
	try {
		cb(null,await Agent.find(qs))
	} catch(e){
		cb(e);
	}
}

exports.findKouling = async function(qs,cb) {
	try {
		cb(null,await Kouling.find(qs))
	} catch(e){
		cb(e);
	}
}