const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    title: {
        type: String,
        required: true
    },
    content: {
        type: String,
        required: true
    },
    type: {
        type: String,
        required: false
    },
    links: {
        type: [Object],
        default: [],
        required: false
    }
}, {
    timestamps: true
});

schema.index({title: 1});
module.exports = mongoose.model('tao-article', schema);
