var express = require('express');
var path = require('path');
var favicon = require('serve-favicon');
var logger = require('morgan');
var cookieParser = require('cookie-parser');
var bodyParser = require('body-parser');
var config  =require('./config/index');
var index = require('./routes/index');
var generator = require('./routes/generator');
var tao = require('./routes/tao');
var mongoose = require('mongoose');
var moment = require('moment');

var app = express();
const options = {
    useMongoClient: true
};
global.Promise = mongoose.Promise = require('bluebird');
mongoose.connect(config.mongo, options);

app.use(function(req, res, next) {
    res.setHeader('Access-Control-Allow-Origin', req.headers && req.headers.origin ? req.headers.origin : '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');
    res.setHeader('Access-Control-Allow-Credentials', true);

    if (req.method === 'OPTIONS')
        return res.status(200).end();

    next();
})
// view engine setup
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

app.use(logger('dev'));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));

app.use('/', index);
app.use('/generator', generator);
app.use('/jump', function(req,res,next){
  res.render('jump');
});
app.use('/test1', function(req,res,next){
   res.render('test');
});
app.use('/tao',tao);
app.get('/code', function(req,res,next){
   res.send('var cptext_tkl = "￥qdqE07mYDQa￥";');
});

app.get('/lottery',function(req,res){
    var lastLoaded = req.cookies['last-loaded'];
    if( lastLoaded && moment(lastLoaded,'x').format('YYYYMMDD') !== moment().format('YYYYMMDD') ){
      res.cookie('times',0);
      res.clearCookie('prize');
    }
    res.cookie('last-loaded',new moment().format('x'));
      res.render('lottery');
  });
// catch 404 and forward to error handler
app.use(function(req, res, next) {
  var err = new Error('Not Found');
  err.status = 404;
  next(err);
});

// error handler
app.use(function(err, req, res, next) {
  // set locals, only providing error in development
  res.locals.message = err.message;
  res.locals.error = req.app.get('env') === 'development' ? err : {};

  // render the error page
  res.status(err.status || 500);
  res.render('error');
});

app.listen(config.port);

console.log('* running, port:', config.port);
console.log('* app env:', app.get('env'));

module.exports = app;
