var express = require('express');
var router = express.Router();
var generator = require('../lib/generator');
var hash = require('../util/hash');
var tao = require('../lib/tao');
var agent = require('../lib/tao-agent');
var kouling = require('../lib/tao-kouling');
var log = require('../lib/tao-log');
var mongoose = require('mongoose');
var config = require('../config/index');
var vipshop = require('../lib/vishop-log');
var moment = require('moment');
var request = require('request');
/* GET home page. */
router.post('/agent', async function (req, res, next) {
   	let {user,password,role = 'channel'} = req.body;
   	if(!user || !password) res.status(400).send('params not full error');
   	else{
   		password = hash.create(password);
   		var u = await agent.findOne({user:user});
   		if(!u) 
   			tao.saveAgent({user,password,role},function(e,result){
   				res.send({status:'ok',result:result});
   			});
   		else 
   			res.status(400).send('already  exsits error');
   	}
});
router.post('/tb_kl', async function (req, res, next) {
  	let {info,creater,status = 'use'} = req.body;
   	if(!info || !creater) res.status(400).send('params not full error');
   	else{
   		var kl = await kouling.findOne({info:info});
   		creater = mongoose.Types.ObjectId(creater);
   		if(!kl) 
   			tao.saveKouling({info,creater,status},function(e,result){
   				res.send({status:'ok',result:result});
   			});
   		else 
   			res.status(400).send('already  exsits error');
   	}	 
});



router.get('/tb_kl', async function (req, res, next) {
	var options = {limit: 10000, skip: 0, sort: {}};
	var qd = req.query.qd;
	var kls = await kouling.find({creater:mongoose.Types.ObjectId(qd),status:'use'}, null, options);
  if(kls && kls.length){
    kls = kls.map(x => x.toJSON());
    var kl = kls[Math.floor(Math.random()*kls.length)];
    var k = 'var cptext_tkl = "';
    var date = moment().format('YYYYMMDD');
    await log.update({key:kl.info,schedule:kl.schedule,link:kl.link,date:date},{'$inc':{times:1}},{upsert:true});
    res.send(k + kl.info + '";');
  }
  else{
    res.send('var cptext_tkl = "";');
  }
});

router.get('/log/tb_kl', async function (req, res, next) {
  try{
    var options = {limit: 1000, skip: 0, sort: {'updatedAt':-1}};
    var logs = await log.find({},null,options).populate('qd','user role');
    logs = logs.map(x => { var d = x.toJSON();d['updatedAt'] = moment(new Date(d['updatedAt']).getTime(),'x').format('YYYYMMDD HH:mm:ss');return d;});
    res.render('logs.ejs',{logs:logs});
  }catch(e){
    console.dir(e);
  }
});

router.get('/log/vipshop', async function (req, res, next) {
  try{
    console.log('in===');
    var key = req.query.key;
    await vipshop.update({key:key},{'$inc':{times:1}},{upsert:true});
    res.status(204).send("no content");
  }catch(e){
    console.dir(e);
  }
});

module.exports = router;
