var ejs = require('ejs');
var fs = require('fs');
var data = require('./data');
var hash = require('../util/hash');

var content = fs.readFileSync(__dirname+'/../views/template/content.ejs', 'utf-8');

const STATIC_PATH = __dirname + '/../public/html/';

function createHtml (pathFile,template,data,callback) {
	
	template = template || content;
	var html = ejs.render(template,data);
	console.dir(html);
	console.dir(STATIC_PATH + pathFile);
	fs.writeFile(STATIC_PATH + pathFile, html, 'utf8', function (err, result) {
        callback(null, html);
    })
}

function createHtmlById(id,callback){

	data.getContentById(id,function(err,result){

		if(err) callback(err);
		if(result && result['data'] && result['data']['content'] && result['data']['content']['content'])
		var path = hash.create(id);
		var date = new Date(millis);
		//console.dir(date.getFullYear() +'-'+ Date(millis).getUTCMonth()+'-'+Date(millis).getUTCMinutes());
		var data = {
			title:result['data']['content']['title'],
			content:result['data']['content']['content'],
			time: millis ? (date.getFullYear() +'-'+ date.getUTCMonth()+'-'+date.getUTCDay()) : ''
		}
		// console.dir(data);
		// console.dir(path);
		createHtml(path+'.html',content,data,callback);

	});
}


module.exports = {
	createHtml : createHtml,
	createHtmlById :createHtmlById
}